/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.ckb.crypto.secp256k1;

import java.math.BigInteger;
import java.security.KeyPair;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.nervos.ckb.crypto.secp256k1.Sign;
import org.nervos.ckb.utils.Numeric;

public class ECKeyPair {
    public static final int PRIVATE_KEY_SIZE = 32;
    private final BigInteger privateKey;
    private final BigInteger publicKey;

    public ECKeyPair(BigInteger privateKey) {
        this.privateKey = privateKey;
        byte[] encoded = ECKeyPair.publicKeyFromPrivate(privateKey, true);
        this.publicKey = new BigInteger(1, encoded);
    }

    public BigInteger getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getEncodedPrivateKey() {
        byte[] encoded = Numeric.toBytesPadded(this.privateKey, 32);
        return encoded;
    }

    public BigInteger getPublicKey() {
        return this.publicKey;
    }

    public byte[] getEncodedPublicKey(boolean compressed) {
        return ECKeyPair.publicKeyFromPrivate(this.privateKey, compressed);
    }

    public static ECKeyPair create(KeyPair keyPair) {
        BCECPrivateKey privateKey = (BCECPrivateKey)keyPair.getPrivate();
        BigInteger privateKeyValue = privateKey.getD();
        return new ECKeyPair(privateKeyValue);
    }

    public static ECKeyPair create(BigInteger privateKey) {
        return new ECKeyPair(privateKey);
    }

    public static ECKeyPair create(String privateKey) {
        return ECKeyPair.create(Numeric.toBigInt(privateKey));
    }

    public static ECKeyPair create(byte[] privateKey) {
        return ECKeyPair.create(Numeric.toBigInt(privateKey));
    }

    public static byte[] publicKeyFromPrivate(BigInteger privateKey, boolean compressed) {
        ECPoint point = ECKeyPair.publicPointFromPrivate(privateKey);
        return point.getEncoded(compressed);
    }

    private static ECPoint publicPointFromPrivate(BigInteger privateKey) {
        if (privateKey.bitLength() > Sign.CURVE.getN().bitLength()) {
            privateKey = privateKey.mod(Sign.CURVE.getN());
        }
        return new FixedPointCombMultiplier().multiply(Sign.CURVE.getG(), privateKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECKeyPair keyPair = (ECKeyPair)o;
        if (!this.privateKey.equals(keyPair.privateKey)) {
            return false;
        }
        return this.publicKey.equals(keyPair.publicKey);
    }

    public int hashCode() {
        int result = this.privateKey.hashCode();
        result = 31 * result + this.publicKey.hashCode();
        return result;
    }
}

