/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.console;

import org.nervos.appchain.codegen.Console;
import org.nervos.appchain.codegen.SolidityFunctionWrapperGenerator;
import org.nervos.appchain.codegen.TruffleJsonFunctionWrapperGenerator;
import org.nervos.appchain.console.WalletRunner;
import org.nervos.appchain.utils.Collection;
import org.nervos.appchain.utils.Version;

public class Runner {
    private static String USAGE = "Usage: nervosj version|wallet|solidity ...";
    private static String LOGO = "\n                                       _\n _ __    ___  _ __ __   __ ___   ___  (_)\n| '_ \\  / _ \\| '__|\\ \\ / // _ \\ / __| | |\n| | | ||  __/| |    \\ V /| (_) |\\__ \\ | |\n|_| |_| \\___||_|     \\_/  \\___/ |___/_/ |\n                                    |__/";

    public static void main(String[] args) throws Exception {
        System.out.println(LOGO);
        if (args.length < 1) {
            Console.exitError((String)USAGE);
        } else {
            switch (args[0]) {
                case "wallet": {
                    WalletRunner.run(Collection.tail((String[])args));
                    break;
                }
                case "solidity": {
                    SolidityFunctionWrapperGenerator.run((String[])Collection.tail((String[])args));
                    break;
                }
                case "truffle": {
                    TruffleJsonFunctionWrapperGenerator.run((String[])Collection.tail((String[])args));
                    break;
                }
                case "version": {
                    Console.exitSuccess((String)("Version: " + Version.getVersion() + "\nBuild timestamp: " + Version.getTimestamp()));
                    break;
                }
                default: {
                    Console.exitError((String)USAGE);
                }
            }
        }
    }
}

