/*
 * Decompiled with CFR 0.152.
 */
package org.abstractj.kalium.keys;

import jnr.ffi.byref.LongLongByReference;
import org.abstractj.kalium.NaCl;
import org.abstractj.kalium.crypto.Util;
import org.abstractj.kalium.encoders.Encoder;

public class VerifyKey {
    private byte[] key;

    public VerifyKey(byte[] key) {
        Util.checkLength(key, 32);
        this.key = key;
    }

    public VerifyKey(String key, Encoder encoder) {
        this(encoder.decode(key));
    }

    public boolean verify(byte[] message, byte[] signature) {
        Util.checkLength(signature, 64);
        byte[] sigAndMsg = Util.merge(signature, message);
        byte[] buffer = Util.zeros(sigAndMsg.length);
        LongLongByReference bufferLen = new LongLongByReference(0L);
        return Util.isValid(NaCl.sodium().crypto_sign_ed25519_open(buffer, bufferLen, sigAndMsg, sigAndMsg.length, this.key), "signature was forged or corrupted");
    }

    public boolean verify(String message, String signature, Encoder encoder) {
        return this.verify(encoder.decode(message), encoder.decode(signature));
    }

    public byte[] toBytes() {
        return this.key;
    }

    public String toString() {
        return Encoder.HEX.encode(this.key);
    }
}

