/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.crypto;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.nervos.appchain.crypto.Credentials;
import org.nervos.appchain.crypto.RawTransaction;
import org.nervos.appchain.crypto.Sign;
import org.nervos.appchain.rlp.RlpEncoder;
import org.nervos.appchain.rlp.RlpList;
import org.nervos.appchain.rlp.RlpString;
import org.nervos.appchain.rlp.RlpType;
import org.nervos.appchain.utils.Bytes;
import org.nervos.appchain.utils.Numeric;

public class TransactionEncoder {
    public static byte[] signMessage(RawTransaction rawTransaction, Credentials credentials) {
        byte[] encodedTransaction = TransactionEncoder.encode(rawTransaction);
        Sign.SignatureData signatureData = Sign.signMessage(encodedTransaction, credentials.getEcKeyPair());
        return TransactionEncoder.encode(rawTransaction, signatureData);
    }

    public static byte[] signMessage(RawTransaction rawTransaction, byte chainId, Credentials credentials) {
        byte[] encodedTransaction = TransactionEncoder.encode(rawTransaction, chainId);
        Sign.SignatureData signatureData = Sign.signMessage(encodedTransaction, credentials.getEcKeyPair());
        Sign.SignatureData eip155SignatureData = TransactionEncoder.createEip155SignatureData(signatureData, chainId);
        return TransactionEncoder.encode(rawTransaction, eip155SignatureData);
    }

    public static Sign.SignatureData createEip155SignatureData(Sign.SignatureData signatureData, byte chainId) {
        byte v = (byte)(signatureData.getV() + (chainId << 1) + 8);
        return new Sign.SignatureData(v, signatureData.getR(), signatureData.getS());
    }

    public static byte[] encode(RawTransaction rawTransaction) {
        return TransactionEncoder.encode(rawTransaction, null);
    }

    public static byte[] encode(RawTransaction rawTransaction, byte chainId) {
        Sign.SignatureData signatureData = new Sign.SignatureData(chainId, new byte[0], new byte[0]);
        return TransactionEncoder.encode(rawTransaction, signatureData);
    }

    private static byte[] encode(RawTransaction rawTransaction, Sign.SignatureData signatureData) {
        List<RlpType> values = TransactionEncoder.asRlpValues(rawTransaction, signatureData);
        RlpList rlpList = new RlpList(values);
        return RlpEncoder.encode((RlpType)rlpList);
    }

    static List<RlpType> asRlpValues(RawTransaction rawTransaction, Sign.SignatureData signatureData) {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)RlpString.create((BigInteger)rawTransaction.getNonce()));
        result.add((RlpType)RlpString.create((BigInteger)rawTransaction.getGasPrice()));
        result.add((RlpType)RlpString.create((BigInteger)rawTransaction.getGasLimit()));
        String to = rawTransaction.getTo();
        if (to != null && to.length() > 0) {
            result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)to)));
        } else {
            result.add((RlpType)RlpString.create((String)""));
        }
        result.add((RlpType)RlpString.create((String)rawTransaction.getValue()));
        byte[] data = Numeric.hexStringToByteArray((String)rawTransaction.getData());
        result.add((RlpType)RlpString.create((byte[])data));
        if (signatureData != null) {
            result.add((RlpType)RlpString.create((byte)signatureData.getV()));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getR())));
            result.add((RlpType)RlpString.create((byte[])Bytes.trimLeadingZeroes((byte[])signatureData.getS())));
        }
        return result;
    }
}

