/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.codegen;

import java.io.File;
import org.nervos.appchain.codegen.Console;

abstract class FunctionWrapperGenerator {
    static final String JAVA_TYPES_ARG = "--javaTypes";
    static final String SOLIDITY_TYPES_ARG = "--solidityTypes";
    final File destinationDirLocation;
    final String basePackageName;
    final boolean useJavaNativeTypes;

    FunctionWrapperGenerator(String destinationDirLocation, String basePackageName, boolean useJavaNativeTypes) {
        this.destinationDirLocation = new File(destinationDirLocation);
        this.basePackageName = basePackageName;
        this.useJavaNativeTypes = useJavaNativeTypes;
    }

    static boolean useJavaNativeTypes(String argVal, String usageString) {
        boolean useJavaNativeTypes = true;
        if (SOLIDITY_TYPES_ARG.equals(argVal)) {
            useJavaNativeTypes = false;
        } else if (JAVA_TYPES_ARG.equals(argVal)) {
            useJavaNativeTypes = true;
        } else {
            Console.exitError(usageString);
        }
        return useJavaNativeTypes;
    }

    static String parsePositionalArg(String[] args, int idx) {
        if (args != null && args.length > idx) {
            return args[idx];
        }
        return "";
    }

    static String parseParameterArgument(String[] args, String ... parameters) {
        for (String parameter : parameters) {
            for (int i = 0; i < args.length; ++i) {
                String parameterValue;
                if (!args[i].equals(parameter) || i + 1 >= args.length || (parameterValue = args[i + 1]).startsWith("-")) continue;
                return parameterValue;
            }
        }
        return "";
    }

    static String getFileNameNoExtension(String fileName) {
        String[] splitName = fileName.split("\\.(?=[^.]*$)");
        return splitName[0];
    }
}

