/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.codegen;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.nervos.appchain.codegen.Console;
import org.nervos.appchain.codegen.FunctionWrapperGenerator;
import org.nervos.appchain.codegen.SolidityFunctionWrapper;
import org.nervos.appchain.protocol.ObjectMapperFactory;
import org.nervos.appchain.protocol.core.methods.response.AbiDefinition;
import org.nervos.appchain.utils.Collection;
import org.nervos.appchain.utils.Files;
import org.nervos.appchain.utils.Strings;

public class SolidityFunctionWrapperGenerator
extends FunctionWrapperGenerator {
    private static final String USAGE = "solidity generate [--javaTypes|--solidityTypes] <input binary file>.bin <input abi file>.abi -p|--package <base package name> -o|--output <destination base directory>";
    private final String binaryFileLocation;
    private final String absFileLocation;

    private SolidityFunctionWrapperGenerator(String binaryFileLocation, String absFileLocation, String destinationDirLocation, String basePackageName, boolean useJavaNativeTypes) {
        super(destinationDirLocation, basePackageName, useJavaNativeTypes);
        this.binaryFileLocation = binaryFileLocation;
        this.absFileLocation = absFileLocation;
    }

    public static void run(String[] args) throws Exception {
        if (args.length < 1 || !args[0].equals("generate")) {
            Console.exitError(USAGE);
        } else {
            SolidityFunctionWrapperGenerator.main(Collection.tail((String[])args));
        }
    }

    public static void main(String[] args) throws Exception {
        String[] fullArgs;
        if (args.length == 6) {
            fullArgs = new String[args.length + 1];
            fullArgs[0] = "--javaTypes";
            System.arraycopy(args, 0, fullArgs, 1, args.length);
        } else {
            fullArgs = args;
        }
        if (fullArgs.length != 7) {
            Console.exitError(USAGE);
        }
        boolean useJavaNativeTypes = SolidityFunctionWrapperGenerator.useJavaNativeTypes(fullArgs[0], USAGE);
        String binaryFileLocation = SolidityFunctionWrapperGenerator.parsePositionalArg(fullArgs, 1);
        String absFileLocation = SolidityFunctionWrapperGenerator.parsePositionalArg(fullArgs, 2);
        String destinationDirLocation = SolidityFunctionWrapperGenerator.parseParameterArgument(fullArgs, "-o", "--outputDir");
        String basePackageName = SolidityFunctionWrapperGenerator.parseParameterArgument(fullArgs, "-p", "--package");
        if (binaryFileLocation.equals("") || absFileLocation.equals("") || destinationDirLocation.equals("") || basePackageName.equals("")) {
            Console.exitError(USAGE);
        }
        new SolidityFunctionWrapperGenerator(binaryFileLocation, absFileLocation, destinationDirLocation, basePackageName, useJavaNativeTypes).generate();
    }

    static List<AbiDefinition> loadContractDefinition(File absFile) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        AbiDefinition[] abiDefinition = (AbiDefinition[])objectMapper.readValue(absFile, AbiDefinition[].class);
        return Arrays.asList(abiDefinition);
    }

    private void generate() throws IOException, ClassNotFoundException {
        File binaryFile = new File(this.binaryFileLocation);
        if (!binaryFile.exists()) {
            Console.exitError("Invalid input binary file specified: " + this.binaryFileLocation);
        }
        byte[] bytes = Files.readBytes((File)new File(binaryFile.toURI()));
        String binary = new String(bytes);
        File absFile = new File(this.absFileLocation);
        if (!absFile.exists() || !absFile.canRead()) {
            Console.exitError("Invalid input ABI file specified: " + this.absFileLocation);
        }
        String fileName = absFile.getName();
        String contractName = SolidityFunctionWrapperGenerator.getFileNameNoExtension(fileName);
        bytes = Files.readBytes((File)new File(absFile.toURI()));
        String abi = new String(bytes);
        List<AbiDefinition> functionDefinitions = SolidityFunctionWrapperGenerator.loadContractDefinition(absFile);
        if (functionDefinitions.isEmpty()) {
            Console.exitError("Unable to parse input ABI file");
        } else {
            String className = Strings.capitaliseFirstLetter((String)contractName);
            System.out.printf("Generating " + this.basePackageName + "." + className + " ... ", new Object[0]);
            new SolidityFunctionWrapper(this.useJavaNativeTypes).generateJavaFiles(contractName, binary, abi, this.destinationDirLocation.toString(), this.basePackageName);
            System.out.println("File written to " + this.destinationDirLocation.toString() + "\n");
        }
    }
}

