/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.core;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.nervos.appchain.protocol.NervosjService;
import org.nervos.appchain.protocol.core.RemoteCall;
import org.nervos.appchain.protocol.core.Response;
import rx.Observable;

public class Request<S, T extends Response> {
    private static AtomicLong nextId = new AtomicLong(0L);
    private String jsonrpc = "2.0";
    private String method;
    private List<S> params;
    private long id;
    private NervosjService nervosjService;
    private Class<T> responseType;

    public Request() {
    }

    public Request(String method, List<S> params, NervosjService nervosjService, Class<T> type) {
        this.method = method;
        this.params = params;
        this.id = nextId.getAndIncrement();
        this.nervosjService = nervosjService;
        this.responseType = type;
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public void setJsonrpc(String jsonrpc) {
        this.jsonrpc = jsonrpc;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public List<S> getParams() {
        return this.params;
    }

    public void setParams(List<S> params) {
        this.params = params;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public T send() throws IOException {
        return this.nervosjService.send(this, this.responseType);
    }

    public CompletableFuture<T> sendAsync() {
        return this.nervosjService.sendAsync(this, this.responseType);
    }

    public Observable<T> observable() {
        return new RemoteCall<Response>(this::send).observable();
    }
}

