/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.core.filters;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.nervos.appchain.protocol.Nervosj;
import org.nervos.appchain.protocol.core.Request;
import org.nervos.appchain.protocol.core.Response;
import org.nervos.appchain.protocol.core.filters.Callback;
import org.nervos.appchain.protocol.core.filters.FilterException;
import org.nervos.appchain.protocol.core.methods.response.AppFilter;
import org.nervos.appchain.protocol.core.methods.response.AppLog;
import org.nervos.appchain.protocol.core.methods.response.AppUninstallFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Filter<T> {
    private static final Logger log = LoggerFactory.getLogger(Filter.class);
    final Nervosj nervosj;
    final Callback<T> callback;
    private volatile BigInteger filterId;
    private ScheduledFuture<?> schedule;

    public Filter(Nervosj nervosj, Callback<T> callback) {
        this.nervosj = nervosj;
        this.callback = callback;
    }

    public void run(ScheduledExecutorService scheduledExecutorService, long blockTime) {
        try {
            AppFilter appFilter = this.sendRequest();
            if (appFilter.hasError()) {
                this.throwException(appFilter.getError());
            }
            this.filterId = appFilter.getFilterId();
            this.getInitialFilterLogs();
            this.schedule = scheduledExecutorService.scheduleAtFixedRate(() -> {
                try {
                    this.pollFilter(appFilter);
                }
                catch (Throwable e) {
                    log.error("Error sending request", e);
                }
            }, 0L, blockTime, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    private void getInitialFilterLogs() {
        try {
            Optional<Request<?, AppLog>> maybeRequest = this.getFilterLogs(this.filterId);
            AppLog appLog = null;
            if (maybeRequest.isPresent()) {
                appLog = maybeRequest.get().send();
            } else {
                appLog = new AppLog();
                appLog.setResult(Collections.emptyList());
            }
            this.process(appLog.getLogs());
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    private void pollFilter(AppFilter appFilter) {
        Response appLog = null;
        try {
            appLog = this.nervosj.appGetFilterChanges(this.filterId).send();
        }
        catch (IOException e) {
            this.throwException(e);
        }
        if (appLog.hasError()) {
            this.throwException(appFilter.getError());
        } else {
            this.process(((AppLog)appLog).getLogs());
        }
    }

    abstract AppFilter sendRequest() throws IOException;

    abstract void process(List<AppLog.LogResult> var1);

    public void cancel() {
        this.schedule.cancel(false);
        Response appUninstallFilter = null;
        try {
            appUninstallFilter = this.nervosj.appUninstallFilter(this.filterId).send();
        }
        catch (IOException e) {
            this.throwException(e);
        }
        if (appUninstallFilter.hasError()) {
            this.throwException(appUninstallFilter.getError());
        }
        if (!((AppUninstallFilter)appUninstallFilter).isUninstalled()) {
            this.throwException(appUninstallFilter.getError());
        }
    }

    protected abstract Optional<Request<?, AppLog>> getFilterLogs(BigInteger var1);

    void throwException(Response.Error error) {
        throw new FilterException("Invalid request: " + (error == null ? "Unknown Error" : error.getMessage()));
    }

    void throwException(Throwable cause) {
        throw new FilterException("Error sending request", cause);
    }
}

