/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.core.methods.response;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nervos.appchain.protocol.core.Response;
import org.nervos.appchain.protocol.core.methods.response.Transaction;
import org.nervos.appchain.utils.Numeric;

public class AppBlock
extends Response<Block> {
    @Override
    @JsonDeserialize(using=ResponseDeserialiser.class)
    public void setResult(Block result) {
        super.setResult(result);
    }

    public Block getBlock() {
        return (Block)this.getResult();
    }

    public boolean isEmpty() {
        return this.getResult() == null;
    }

    public static class ResponseDeserialiser
    extends JsonDeserializer<Block> {
        public Block deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
                JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                String blockVersion = node.get("version").asText();
                String blockHash = node.get("hash").asText();
                JsonNode headerNode = node.get("header");
                Long timeStamp = headerNode.get("timestamp").asLong();
                String prevHash = headerNode.get("prevHash").asText();
                String number = headerNode.get("number").asText();
                String stateRoot = headerNode.get("stateRoot").asText();
                String transactionsRoot = headerNode.get("transactionsRoot").asText();
                String receiptsRoot = headerNode.get("receiptsRoot").asText();
                String gasUsed = headerNode.get("gasUsed").asText();
                JsonNode proofNode = node.get("header").get("proof").get("Bft");
                String proposal = proofNode.get("proposal").asText();
                String height = proofNode.get("height").asText();
                String round = proofNode.get("round").asText();
                ArrayList<TendermintCommit> tendermintCommits = new ArrayList<TendermintCommit>();
                JsonNode commitsNode = node.get("header").get("proof").get("Bft").get("commits");
                Iterator commitsAddress = commitsNode.fieldNames();
                while (commitsAddress.hasNext()) {
                    String commitAddress = (String)commitsAddress.next();
                    String commit = commitsNode.get(commitAddress).asText();
                    tendermintCommits.add(new TendermintCommit(commitAddress, commit));
                }
                ArrayList<TransactionObject> transactionObjs = new ArrayList<TransactionObject>();
                JsonNode transactionNode = node.get("body").get("transactions");
                Iterator txNodes = transactionNode.elements();
                while (txNodes.hasNext()) {
                    JsonNode txNode = (JsonNode)txNodes.next();
                    TransactionObject txToAdd = new TransactionObject();
                    txToAdd.setHash(txNode.get("hash").asText());
                    txToAdd.setContent(txNode.get("content").asText());
                    transactionObjs.add(txToAdd);
                }
                Tendermint tendermint = new Tendermint(proposal, height, round, tendermintCommits.toArray(new TendermintCommit[tendermintCommits.size()]));
                Header header = new Header(timeStamp, prevHash, number, stateRoot, transactionsRoot, receiptsRoot, gasUsed, new Proof(tendermint));
                Body body = new Body(transactionObjs);
                return new Block(blockVersion, blockHash, header, body);
            }
            return null;
        }
    }

    public static class TransactionObject
    extends Transaction
    implements TransactionResult<Transaction> {
        public TransactionObject() {
        }

        public TransactionObject(String hash, String blockHash, String blockNumber, String content, String index) {
            super(hash, blockHash, blockNumber, content, index);
        }

        @Override
        public Transaction get() {
            return this;
        }
    }

    public static interface TransactionResult<T> {
        public T get();
    }

    public static class Block {
        private String version;
        private String hash;
        private Header header;
        private Body body;

        public Block() {
        }

        public Block(String version, String hash, Header header, Body body) {
            this.version = version;
            this.hash = hash;
            this.header = header;
            this.body = body;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public Header getHeader() {
            return this.header;
        }

        public void setHeader(Header header) {
            this.header = header;
        }

        public Body getBody() {
            return this.body;
        }

        public void setBody(Body body) {
            this.body = body;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Block)) {
                return false;
            }
            Block block = (Block)o;
            if (this.getHeader() != null ? !this.getHeader().equals(block.getHeader()) : block.getHeader() != null) {
                return false;
            }
            if (this.getBody() != null ? !this.getBody().equals(block.getBody()) : block.getBody() != null) {
                return false;
            }
            if (this.getHash() != null ? !this.getHash().equals(block.getHash()) : block.getHash() != null) {
                return false;
            }
            return this.getVersion() != null ? this.getVersion().equals(block.getVersion()) : block.getVersion() == null;
        }

        public int hashCode() {
            int result = this.getVersion() != null ? this.getVersion().hashCode() : 0;
            result = 31 * result + (this.getHash() != null ? this.getHash().hashCode() : 0);
            result = 31 * result + (this.getHeader() != null ? this.getHeader().hashCode() : 0);
            result = 31 * result + (this.getBody() != null ? this.getBody().hashCode() : 0);
            return result;
        }
    }

    public static class Body {
        private List<TransactionObject> transactions;

        public Body() {
        }

        public Body(List<TransactionObject> transactions) {
            this.transactions = transactions;
        }

        public List<TransactionObject> getTransactions() {
            return this.transactions;
        }

        public void setTransactions(List<TransactionObject> transactions) {
            this.transactions = transactions;
        }

        public int hashCode() {
            int result = this.getTransactions() != null ? this.getTransactions().hashCode() : 0;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Body)) {
                return false;
            }
            Body body = (Body)o;
            return this.getTransactions() != null ? this.getTransactions().equals(body.getTransactions()) : body.getTransactions() == null;
        }
    }

    public static class Header {
        private Long timestamp;
        private String prevHash;
        private String number;
        private String stateRoot;
        private String transactionsRoot;
        private String receiptsRoot;
        private String gasUsed;
        private Proof proof;

        public Header() {
        }

        public Header(long timestamp, String prevHash, String number, String stateRoot, String transactionsRoot, String receiptsRoot, String gasUsed, Proof proof) {
            this.timestamp = timestamp;
            this.prevHash = prevHash;
            this.number = number;
            this.stateRoot = stateRoot;
            this.transactionsRoot = transactionsRoot;
            this.receiptsRoot = receiptsRoot;
            this.gasUsed = gasUsed;
            this.proof = proof;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String getPrevHash() {
            return this.prevHash;
        }

        public void setPrevHash(String prevHash) {
            this.prevHash = prevHash;
        }

        public BigInteger getNumberDec() {
            return Numeric.decodeQuantity((String)this.number);
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getStateRoot() {
            return this.stateRoot;
        }

        public void setStateRoot(String stateRoot) {
            this.stateRoot = stateRoot;
        }

        public String getTransactionsRoot() {
            return this.transactionsRoot;
        }

        public void setTransactionsRoot(String transactionsRoot) {
            this.transactionsRoot = transactionsRoot;
        }

        public String getReceiptsRoot() {
            return this.receiptsRoot;
        }

        public void setReceiptsRoot(String receiptsRoot) {
            this.receiptsRoot = receiptsRoot;
        }

        public BigInteger getGasUsedDec() {
            return Numeric.decodeQuantity((String)this.gasUsed);
        }

        public String getGasUsed() {
            return this.gasUsed;
        }

        public void setGasUsed(String gasUsed) {
            this.gasUsed = gasUsed;
        }

        public Proof getProof() {
            return this.proof;
        }

        public void setProof(Proof proof) {
            this.proof = proof;
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.getPrevHash() != null ? this.getPrevHash().hashCode() : 0);
            result = 31 * result + (this.getNumber() != null ? this.getNumber().hashCode() : 0);
            result = 31 * result + (this.getStateRoot() != null ? this.getStateRoot().hashCode() : 0);
            result = 31 * result + (this.getTransactionsRoot() != null ? this.getTransactionsRoot().hashCode() : 0);
            result = 31 * result + (this.getReceiptsRoot() != null ? this.getReceiptsRoot().hashCode() : 0);
            result = 31 * result + (this.getGasUsed() != null ? this.getGasUsed().hashCode() : 0);
            result = 31 * result + (this.getProof() != null ? this.getProof().hashCode() : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Header)) {
                return false;
            }
            Header header = (Header)o;
            if (this.getTimestamp() != null ? !this.getTimestamp().equals(header.getTimestamp()) : header.getTimestamp() != null) {
                return false;
            }
            if (this.getPrevHash() != null ? !this.getPrevHash().equals(header.getPrevHash()) : header.getPrevHash() != null) {
                return false;
            }
            if (this.getNumber() != null ? !this.getNumber().equals(header.getNumber()) : header.getNumber() != null) {
                return false;
            }
            if (this.getStateRoot() != null ? !this.getStateRoot().equals(header.getStateRoot()) : header.getStateRoot() != null) {
                return false;
            }
            if (this.getTransactionsRoot() != null ? !this.getTransactionsRoot().equals(header.getTransactionsRoot()) : header.getTransactionsRoot() != null) {
                return false;
            }
            if (this.getReceiptsRoot() != null ? !this.getReceiptsRoot().equals(header.getReceiptsRoot()) : header.getReceiptsRoot() != null) {
                return false;
            }
            if (this.getGasUsed() != null ? !this.getGasUsed().equals(header.getGasUsed()) : header.getGasUsed() != null) {
                return false;
            }
            if (this.getReceiptsRoot() != null ? !this.getReceiptsRoot().equals(header.getReceiptsRoot()) : header.getReceiptsRoot() != null) {
                return false;
            }
            return this.getProof() != null ? this.getProof().equals(header.getProof()) : header.getProof() == null;
        }
    }

    public static class Proof {
        private Tendermint tendermint;

        public Proof() {
        }

        public Proof(Tendermint tendermint) {
            this.tendermint = tendermint;
        }

        public Tendermint getTendermint() {
            return this.tendermint;
        }

        public void setTendermint(Tendermint tendermint) {
            this.tendermint = tendermint;
        }

        public int hashCode() {
            int result = this.getTendermint() != null ? this.getTendermint().hashCode() : 0;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Proof)) {
                return false;
            }
            Proof proof = (Proof)o;
            return this.getTendermint() != null ? this.getTendermint().equals(proof.getTendermint()) : proof.getTendermint() == null;
        }
    }

    public static class Tendermint {
        private String proposal;
        private String height;
        private String round;
        private TendermintCommit[] tendermintCommits;

        public Tendermint() {
        }

        public Tendermint(String proposal, String height, String round, TendermintCommit[] tendermintCommits) {
            this.proposal = proposal;
            this.height = height;
            this.round = round;
            this.tendermintCommits = tendermintCommits;
        }

        public String getProposal() {
            return this.proposal;
        }

        public void setProposal(String proposal) {
            this.proposal = proposal;
        }

        public String getHeight() {
            return this.height;
        }

        public void setHeight(String height) {
            this.height = height;
        }

        public String getRound() {
            return this.round;
        }

        public void setRound(String round) {
            this.round = round;
        }

        public TendermintCommit[] getTendermintCommits() {
            return this.tendermintCommits;
        }

        public void setTendermintCommits(TendermintCommit[] tendermintCommits) {
            this.tendermintCommits = tendermintCommits;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Tendermint)) {
                return false;
            }
            Tendermint tendermint = (Tendermint)o;
            if (this.getHeight() != null ? !this.getHeight().equals(tendermint.getHeight()) : tendermint.getHeight() != null) {
                return false;
            }
            if (this.getProposal() != null ? !this.getProposal().equals(tendermint.getProposal()) : tendermint.getProposal() != null) {
                return false;
            }
            return this.getRound() != null ? this.getRound().equals(tendermint.getRound()) : tendermint.getRound() == null;
        }

        public int hashCode() {
            int result = this.getProposal() != null ? this.getProposal().hashCode() : 0;
            result = 31 * result + (this.getHeight() != null ? this.getHeight().hashCode() : 0);
            result = 31 * result + (this.getRound() != null ? this.getRound().hashCode() : 0);
            return result;
        }
    }

    public static class TendermintCommit {
        private String commitAddress;
        private String commit;

        public TendermintCommit() {
        }

        public TendermintCommit(String commitAddress, String commit) {
            this.commitAddress = commitAddress;
            this.commit = commit;
        }

        public String getCommitAddress() {
            return this.commitAddress;
        }

        public void setCommitAddress(String commitAddress) {
            this.commitAddress = commitAddress;
        }

        public String getCommit() {
            return this.commit;
        }

        public void setCommit(String commit) {
            this.commit = commit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TendermintCommit)) {
                return false;
            }
            TendermintCommit commit = (TendermintCommit)o;
            if (this.getCommitAddress() != null ? !this.getCommitAddress().equals(commit.getCommitAddress()) : commit.getCommitAddress() != null) {
                return false;
            }
            return this.getCommit() != null ? this.getCommit().equals(commit.getCommit()) : commit.getCommit() == null;
        }

        public int hashCode() {
            int result = this.getCommitAddress() != null ? this.getCommitAddress().hashCode() : 0;
            result = 31 * result + (this.getCommit() != null ? this.getCommit().hashCode() : 0);
            return result;
        }
    }
}

