/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.tx;

import java.io.IOException;
import java.math.BigInteger;
import org.nervos.appchain.protocol.Nervosj;
import org.nervos.appchain.protocol.core.methods.response.AppSendTransaction;
import org.nervos.appchain.protocol.core.methods.response.TransactionReceipt;
import org.nervos.appchain.protocol.exceptions.TransactionException;
import org.nervos.appchain.tx.response.PollingTransactionReceiptProcessor;
import org.nervos.appchain.tx.response.TransactionReceiptProcessor;

public abstract class TransactionManager {
    public static final int DEFAULT_POLLING_ATTEMPTS_PER_TX_HASH = 40;
    public static final long DEFAULT_POLLING_FREQUENCY = 15000L;
    private final TransactionReceiptProcessor transactionReceiptProcessor;
    private final String fromAddress;

    protected TransactionManager(TransactionReceiptProcessor transactionReceiptProcessor, String fromAddress) {
        this.transactionReceiptProcessor = transactionReceiptProcessor;
        this.fromAddress = fromAddress;
    }

    protected TransactionManager(Nervosj nervosj, String fromAddress) {
        this(new PollingTransactionReceiptProcessor(nervosj, 15000L, 40), fromAddress);
    }

    protected TransactionManager(Nervosj nervosj, int attempts, long sleepDuration, String fromAddress) {
        this(new PollingTransactionReceiptProcessor(nervosj, sleepDuration, attempts), fromAddress);
    }

    protected TransactionReceipt executeTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, String value) throws IOException, TransactionException {
        AppSendTransaction ethSendTransaction = this.sendTransaction(gasPrice, gasLimit, to, data, value);
        return this.processResponse(ethSendTransaction);
    }

    protected TransactionReceipt executeTransaction(String to, String data, long quota, BigInteger nonce, long validUntilBlock, int version, int chainId, String value) throws IOException, TransactionException {
        AppSendTransaction appSendTransaction = this.sendTransaction(to, data, quota, nonce, validUntilBlock, version, chainId, value);
        return this.processResponse(appSendTransaction);
    }

    public AppSendTransaction sendTransaction(String to, String data, long quota, BigInteger nonce, long validUntilBlock, int version, int chainId, String value) throws IOException {
        return new AppSendTransaction();
    }

    public abstract AppSendTransaction sendTransaction(BigInteger var1, BigInteger var2, String var3, String var4, String var5) throws IOException;

    public String getFromAddress() {
        return this.fromAddress;
    }

    private TransactionReceipt processResponse(AppSendTransaction transactionResponse) throws IOException, TransactionException {
        if (transactionResponse.hasError()) {
            throw new RuntimeException("Error processing transaction request: " + transactionResponse.getError().getMessage());
        }
        String transactionHash = transactionResponse.getSendTransactionResult().getHash();
        return this.transactionReceiptProcessor.waitForTransactionReceipt(transactionHash);
    }
}

