/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.tx.response;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.nervos.appchain.protocol.Nervosj;
import org.nervos.appchain.protocol.core.methods.response.TransactionReceipt;
import org.nervos.appchain.protocol.exceptions.TransactionException;
import org.nervos.appchain.tx.response.Callback;
import org.nervos.appchain.tx.response.EmptyTransactionReceipt;
import org.nervos.appchain.tx.response.TransactionReceiptProcessor;
import org.nervos.appchain.utils.Async;

public class QueuingTransactionReceiptProcessor
extends TransactionReceiptProcessor {
    private final int pollingAttemptsPerTxHash;
    private final ScheduledExecutorService scheduledExecutorService = Async.defaultExecutorService();
    private final Callback callback;
    private final BlockingQueue<RequestWrapper> pendingTransactions;

    public QueuingTransactionReceiptProcessor(Nervosj nervosj, Callback callback, int pollingAttemptsPerTxHash, long pollingFrequency) {
        super(nervosj);
        this.callback = callback;
        this.pendingTransactions = new LinkedBlockingQueue<RequestWrapper>();
        this.pollingAttemptsPerTxHash = pollingAttemptsPerTxHash;
        this.scheduledExecutorService.scheduleAtFixedRate(this::sendTransactionReceiptRequests, pollingFrequency, pollingFrequency, TimeUnit.MILLISECONDS);
    }

    @Override
    public TransactionReceipt waitForTransactionReceipt(String transactionHash) throws IOException, TransactionException {
        this.pendingTransactions.add(new RequestWrapper(transactionHash));
        return new EmptyTransactionReceipt(transactionHash);
    }

    private void sendTransactionReceiptRequests() {
        for (RequestWrapper requestWrapper : this.pendingTransactions) {
            try {
                String transactionHash = requestWrapper.getTransactionHash();
                Optional<TransactionReceipt> transactionReceipt = this.sendTransactionReceiptRequest(transactionHash);
                if (transactionReceipt.isPresent()) {
                    this.callback.accept(transactionReceipt.get());
                    this.pendingTransactions.remove(requestWrapper);
                    continue;
                }
                if (requestWrapper.getCount() == this.pollingAttemptsPerTxHash) {
                    throw new TransactionException("No transaction receipt for txHash: " + transactionHash + "received after " + this.pollingAttemptsPerTxHash + " attempts");
                }
                requestWrapper.incrementCount();
            }
            catch (IOException | TransactionException e) {
                this.pendingTransactions.remove(requestWrapper);
                this.callback.exception(e);
            }
        }
    }

    private static class RequestWrapper {
        private final String transactionHash;
        private int count;

        RequestWrapper(String transactionHash) {
            this.transactionHash = transactionHash;
            this.count = 0;
        }

        String getTransactionHash() {
            return this.transactionHash;
        }

        int getCount() {
            return this.count;
        }

        void incrementCount() {
            ++this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestWrapper that = (RequestWrapper)o;
            return this.transactionHash.equals(that.transactionHash);
        }

        public int hashCode() {
            return this.transactionHash.hashCode();
        }
    }
}

