/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.crypto;

import org.nervos.appchain.crypto.ECKeyPair;
import org.nervos.appchain.crypto.Keys;
import org.nervos.appchain.utils.Numeric;

public class Credentials {
    private final ECKeyPair ecKeyPair;
    private final String address;

    private Credentials(ECKeyPair ecKeyPair, String address) {
        this.ecKeyPair = ecKeyPair;
        this.address = address;
    }

    public ECKeyPair getEcKeyPair() {
        return this.ecKeyPair;
    }

    public String getAddress() {
        return this.address;
    }

    public static Credentials create(ECKeyPair ecKeyPair) {
        String address = Numeric.prependHexPrefix((String)Keys.getAddress(ecKeyPair));
        return new Credentials(ecKeyPair, address);
    }

    public static Credentials create(String privateKey, String publicKey) {
        return Credentials.create(new ECKeyPair(Numeric.toBigInt((String)privateKey), Numeric.toBigInt((String)publicKey)));
    }

    public static Credentials create(String privateKey) {
        return Credentials.create(ECKeyPair.create(Numeric.toBigInt((String)privateKey)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credentials that = (Credentials)o;
        if (this.ecKeyPair != null ? !this.ecKeyPair.equals(that.ecKeyPair) : that.ecKeyPair != null) {
            return false;
        }
        return this.address != null ? this.address.equals(that.address) : that.address == null;
    }

    public int hashCode() {
        int result = this.ecKeyPair != null ? this.ecKeyPair.hashCode() : 0;
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        return result;
    }
}

