/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.core.filters;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.nervos.appchain.protocol.Nervosj;
import org.nervos.appchain.protocol.core.Request;
import org.nervos.appchain.protocol.core.filters.Callback;
import org.nervos.appchain.protocol.core.filters.Filter;
import org.nervos.appchain.protocol.core.filters.FilterException;
import org.nervos.appchain.protocol.core.methods.request.AppFilter;
import org.nervos.appchain.protocol.core.methods.response.AppLog;
import org.nervos.appchain.protocol.core.methods.response.Log;

public class LogFilter
extends Filter<Log> {
    private final AppFilter ethFilter;

    public LogFilter(Nervosj nervosj, Callback<Log> callback, AppFilter ethFilter) {
        super(nervosj, callback);
        this.ethFilter = ethFilter;
    }

    @Override
    org.nervos.appchain.protocol.core.methods.response.AppFilter sendRequest() throws IOException {
        return this.nervosj.appNewFilter(this.ethFilter).send();
    }

    @Override
    void process(List<AppLog.LogResult> logResults) {
        for (AppLog.LogResult logResult : logResults) {
            if (logResult instanceof AppLog.LogObject) {
                Log log = ((AppLog.LogObject)logResult).get();
                this.callback.onEvent(log);
                continue;
            }
            throw new FilterException("Unexpected result type: " + logResult.get() + " required LogObject");
        }
    }

    @Override
    protected Optional<Request<?, AppLog>> getFilterLogs(BigInteger filterId) {
        return Optional.of(this.nervosj.appGetFilterLogs(filterId));
    }
}

