/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.core.methods.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigInteger;
import org.abstractj.kalium.crypto.Hash;
import org.abstractj.kalium.encoders.Encoder;
import org.abstractj.kalium.keys.SigningKey;
import org.nervos.appchain.crypto.Credentials;
import org.nervos.appchain.crypto.ECKeyPair;
import org.nervos.appchain.crypto.Sign;
import org.nervos.appchain.crypto.Signature;
import org.nervos.appchain.protobuf.Blockchain;
import org.nervos.appchain.protobuf.ConvertStrByte;
import org.nervos.appchain.utils.Numeric;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Transaction {
    private String to;
    private BigInteger nonce;
    private long quota;
    private long validUntilBlock;
    private int version = 0;
    private String data;
    private String value;
    private int chainId;
    private final Hash hash = new Hash();
    private static final BigInteger MAX_VALUE = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16);

    public Transaction(String to, BigInteger nonce, long quota, long validUntilBlock, int version, int chainId, String value, String data) {
        this.to = to;
        this.nonce = nonce;
        this.quota = quota;
        this.version = version;
        this.validUntilBlock = validUntilBlock;
        this.chainId = chainId;
        this.value = value;
        if (data != null) {
            this.data = Numeric.prependHexPrefix((String)data);
        }
        this.value = Transaction.processValue(value);
    }

    public static String processValue(String value) {
        String result = "";
        result = value.matches("0[xX][0-9a-fA-F]+") ? value.substring(2) : (value == null || value.equals("") ? "0" : new BigInteger(value).toString(16));
        BigInteger valueBigInt = new BigInteger(result, 16);
        if (MAX_VALUE.compareTo(valueBigInt) > 0) {
            return result;
        }
        System.out.println("Value you input is out of bound");
        System.out.println("Value is set as 0");
        return "0";
    }

    public static Transaction createContractTransaction(BigInteger nonce, long quota, long validUntilBlock, int version, int chainId, String value, String init) {
        return new Transaction("", nonce, quota, validUntilBlock, version, chainId, value, init);
    }

    public static Transaction createFunctionCallTransaction(String to, BigInteger nonce, long quota, long validUntilBlock, int version, int chainId, String value, String data) {
        return new Transaction(to, nonce, quota, validUntilBlock, version, chainId, value, data);
    }

    public static Transaction createFunctionCallTransaction(String to, BigInteger nonce, long quota, long validUntilBlock, int version, int chainId, String value, byte[] data) {
        return new Transaction(to, nonce, quota, validUntilBlock, version, chainId, value, new String(data));
    }

    public String getTo() {
        return this.to;
    }

    public String getNonce() {
        return Transaction.convert(this.nonce);
    }

    public long getQuota() {
        return this.quota;
    }

    public long get_valid_until_block() {
        return this.validUntilBlock;
    }

    public int getVersion() {
        return this.version;
    }

    public String getData() {
        return this.data;
    }

    public int getChainId() {
        return this.chainId;
    }

    public String getValue() {
        return this.value;
    }

    private static String convert(BigInteger value) {
        if (value != null) {
            return Numeric.cleanHexPrefix((String)Numeric.encodeQuantity((BigInteger)value));
        }
        return null;
    }

    public String sign(String privateKey, boolean isEd25519AndBlake2b, boolean isByteArray) {
        byte[] tx = this.serializeRawTransaction(isByteArray);
        byte[] sig = this.getSignature(privateKey, tx, isEd25519AndBlake2b);
        return this.serializeUnverifiedTransaction(sig, tx);
    }

    public String sign(String privateKey) {
        return this.sign(privateKey, false, false);
    }

    public String sign(Credentials credentials) {
        byte[] tx = this.serializeRawTransaction(false);
        byte[] sig = this.getSignature(credentials, tx);
        return this.serializeUnverifiedTransaction(sig, tx);
    }

    public String sign(Signature signature) {
        byte[] tx = this.serializeRawTransaction(false);
        byte[] sig = signature.getSignature(tx);
        return this.serializeUnverifiedTransaction(sig, tx);
    }

    public byte[] serializeRawTransaction(boolean isByteArray) {
        Blockchain.Transaction.Builder builder = Blockchain.Transaction.newBuilder();
        byte[] strbyte = isByteArray ? this.getData().getBytes() : ConvertStrByte.hexStringToBytes((String)Numeric.cleanHexPrefix((String)this.getData()));
        ByteString bdata = ByteString.copyFrom((byte[])strbyte);
        byte[] byteValue = ConvertStrByte.hexStringToBytes((String)Numeric.cleanHexPrefix((String)this.getValue()), (int)256);
        ByteString bvalue = ByteString.copyFrom((byte[])byteValue);
        builder.setData(bdata);
        builder.setNonce(this.getNonce());
        builder.setTo(this.getTo());
        builder.setValidUntilBlock(this.get_valid_until_block());
        builder.setQuota(this.getQuota());
        builder.setVersion(this.getVersion());
        builder.setChainId(this.getChainId());
        builder.setValue(bvalue);
        return builder.build().toByteArray();
    }

    public byte[] getSignature(Credentials credentials, byte[] tx) {
        ECKeyPair keyPair = credentials.getEcKeyPair();
        Sign.SignatureData signatureData = Sign.signMessage((byte[])tx, (ECKeyPair)keyPair);
        return signatureData.get_signature();
    }

    public byte[] getSignature(String privateKey, byte[] tx, boolean isEd25519AndBlake2b) {
        byte[] sig;
        Hash hash = new Hash();
        if (isEd25519AndBlake2b) {
            byte[] message = hash.blake2(tx, "CryptapeCryptape".getBytes(), null, null);
            SigningKey key = new SigningKey(privateKey, (Encoder)Encoder.HEX);
            byte[] pk = key.getVerifyKey().toBytes();
            byte[] signature = key.sign(message);
            sig = new byte[signature.length + pk.length];
            System.arraycopy(signature, 0, sig, 0, signature.length);
            System.arraycopy(pk, 0, sig, signature.length, pk.length);
        } else {
            Credentials credentials = Credentials.create((String)privateKey);
            ECKeyPair keyPair = credentials.getEcKeyPair();
            Sign.SignatureData signatureData = Sign.signMessage((byte[])tx, (ECKeyPair)keyPair);
            sig = signatureData.get_signature();
        }
        return sig;
    }

    public String serializeUnverifiedTransaction(byte[] sig, byte[] tx) {
        Blockchain.UnverifiedTransaction utx = null;
        try {
            Blockchain.Transaction transaction = Blockchain.Transaction.parseFrom((byte[])tx);
            Blockchain.UnverifiedTransaction.Builder builder = Blockchain.UnverifiedTransaction.newBuilder();
            builder.setTransaction(transaction);
            builder.setSignature(ByteString.copyFrom((byte[])sig));
            builder.setCrypto(Blockchain.Crypto.SECP);
            utx = builder.build();
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        String txStr = ConvertStrByte.bytesToHexString((byte[])utx.toByteArray());
        return Numeric.prependHexPrefix((String)txStr);
    }
}

