/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.tx;

import java.io.IOException;
import java.math.BigInteger;
import org.nervos.appchain.crypto.Credentials;
import org.nervos.appchain.protocol.Nervosj;
import org.nervos.appchain.tx.RawTransactionManager;
import org.nervos.appchain.tx.response.TransactionReceiptProcessor;

public class FastRawTransactionManager
extends RawTransactionManager {
    private volatile BigInteger nonce = BigInteger.valueOf(-1L);

    public FastRawTransactionManager(Nervosj nervosj, Credentials credentials, byte chainId) {
        super(nervosj, credentials, chainId);
    }

    public FastRawTransactionManager(Nervosj nervosj, Credentials credentials) {
        super(nervosj, credentials);
    }

    public FastRawTransactionManager(Nervosj nervosj, Credentials credentials, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(nervosj, credentials, (byte)-1, transactionReceiptProcessor);
    }

    public FastRawTransactionManager(Nervosj nervosj, Credentials credentials, byte chainId, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(nervosj, credentials, chainId, transactionReceiptProcessor);
    }

    @Override
    protected synchronized BigInteger getNonce() throws IOException {
        this.nonce = this.nonce.signum() == -1 ? super.getNonce() : this.nonce.add(BigInteger.ONE);
        return this.nonce;
    }

    public BigInteger getCurrentNonce() {
        return this.nonce;
    }

    public synchronized void resetNonce() throws IOException {
        this.nonce = super.getNonce();
    }

    public synchronized void setNonce(BigInteger value) {
        this.nonce = value;
    }
}

