/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.tx;

import java.io.IOException;
import java.math.BigInteger;
import org.nervos.appchain.protocol.Nervosj;
import org.nervos.appchain.protocol.core.methods.response.TransactionReceipt;
import org.nervos.appchain.protocol.exceptions.TransactionException;
import org.nervos.appchain.tx.TransactionManager;

public abstract class ManagedTransaction {
    public static final BigInteger GAS_PRICE = BigInteger.valueOf(22000000000L);
    protected Nervosj nervosj;
    protected TransactionManager transactionManager;

    protected ManagedTransaction(Nervosj nervosj, TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.nervosj = nervosj;
    }

    protected TransactionReceipt send(String to, String data, String value, BigInteger gasPrice, BigInteger gasLimit) throws IOException, TransactionException {
        return this.transactionManager.executeTransaction(gasPrice, gasLimit, to, data, value);
    }

    protected TransactionReceipt sendAdaptToCita(String to, String data, long quota, BigInteger nonce, long validUntilBlock, int version, int chainId, String value) throws IOException, TransactionException {
        return this.transactionManager.executeTransaction(to, data, quota, nonce, validUntilBlock, version, chainId, value);
    }
}

