/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.tx.response;

import java.io.IOException;
import java.util.Optional;
import org.nervos.appchain.protocol.Nervosj;
import org.nervos.appchain.protocol.core.methods.response.AppGetTransactionReceipt;
import org.nervos.appchain.protocol.core.methods.response.TransactionReceipt;
import org.nervos.appchain.protocol.exceptions.TransactionException;

public abstract class TransactionReceiptProcessor {
    private final Nervosj nervosj;

    public TransactionReceiptProcessor(Nervosj nervosj) {
        this.nervosj = nervosj;
    }

    public abstract TransactionReceipt waitForTransactionReceipt(String var1) throws IOException, TransactionException;

    Optional<TransactionReceipt> sendTransactionReceiptRequest(String transactionHash) throws IOException, TransactionException {
        AppGetTransactionReceipt transactionReceipt = this.nervosj.appGetTransactionReceipt(transactionHash).send();
        if (transactionReceipt.hasError()) {
            throw new TransactionException("Error processing request: " + transactionReceipt.getError().getMessage());
        }
        return transactionReceipt.getTransactionReceipt();
    }
}

