/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.nervos.appchain.abi.TypeReference;
import org.nervos.appchain.abi.datatypes.Address;
import org.nervos.appchain.abi.datatypes.Bool;
import org.nervos.appchain.abi.datatypes.DynamicArray;
import org.nervos.appchain.abi.datatypes.DynamicBytes;
import org.nervos.appchain.abi.datatypes.StaticArray;
import org.nervos.appchain.abi.datatypes.Type;
import org.nervos.appchain.abi.datatypes.Utf8String;
import org.nervos.appchain.abi.datatypes.generated.AbiTypes;

public class TypedAbi {
    public static ArgRetType getArgRetType(String typeName) {
        String type = TypedAbi.trimStorageDeclaration(typeName);
        if (type.endsWith("]")) {
            String[] splitType = type.split("[\\[\\]]");
            Class baseType = AbiTypes.getType((String)splitType[0]);
            if (splitType.length == 1) {
                return ArgRetType.newDynamicArray(baseType);
            }
            return ArgRetType.newStaticArray(splitType[1], baseType);
        }
        return new ArgRetType(AbiTypes.getType((String)type));
    }

    public static Type getType(String typeName, Object value) throws Exception {
        ArgRetType t = TypedAbi.getArgRetType(typeName);
        return t.javaToAbi(value);
    }

    public static String trimStorageDeclaration(String type) {
        if (type.endsWith(" storage") || type.endsWith(" memory")) {
            return type.split(" ")[0];
        }
        return type;
    }

    public static class ArgRetType {
        private Class<? extends Type> rawType;
        private Class<? extends Type> baseType;

        public ArgRetType(Class rawType, Class baseType) {
            this.rawType = rawType;
            this.baseType = baseType;
        }

        public ArgRetType(Class baseType) {
            this.rawType = null;
            this.baseType = baseType;
        }

        public static ArgRetType newDynamicArray(Class baseType) {
            return new ArgRetType(DynamicArray.class, baseType);
        }

        public static ArgRetType newStaticArray(String length, Class baseType) {
            Class staticArray;
            try {
                staticArray = Class.forName("org.nervos.appchain.abi.datatypes.generated.StaticArray" + length);
            }
            catch (ClassNotFoundException e) {
                staticArray = StaticArray.class;
            }
            return new ArgRetType(staticArray, baseType);
        }

        public Type javaToAbi(Object value) throws Exception {
            if (this.rawType != null) {
                Constructor<? extends Type> arrayCtor = this.rawType.getDeclaredConstructor(List.class);
                ArrayList<Type> list = new ArrayList<Type>();
                if (value.getClass().isArray()) {
                    Object[] args;
                    for (Object arg : args = (Object[])value) {
                        list.add(this.fromSingleJavaValue(arg));
                    }
                } else {
                    List args = (List)value;
                    for (Object arg : args) {
                        list.add(this.fromSingleJavaValue(arg));
                    }
                }
                return arrayCtor.newInstance(list);
            }
            return this.fromSingleJavaValue(value);
        }

        private Type fromSingleJavaValue(Object value) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InvalidAbiType {
            Constructor<Object> ctor;
            String typeName = this.baseType.getSimpleName();
            if (typeName.equals("Address")) {
                ctor = Address.class.getDeclaredConstructor(String.class);
            } else if (typeName.equals("Bool")) {
                ctor = Bool.class.getDeclaredConstructor(Boolean.TYPE);
            } else if (typeName.equals("DynamicBytes")) {
                ctor = DynamicBytes.class.getDeclaredConstructor(byte[].class);
            } else if (typeName.equals("Utf8String")) {
                ctor = Utf8String.class.getDeclaredConstructor(String.class);
            } else if (typeName.startsWith("Uint") || typeName.startsWith("Int")) {
                Class<?> c = Class.forName("org.nervos.appchain.abi.datatypes.generated." + typeName);
                ctor = c.getDeclaredConstructor(BigInteger.class);
            } else if (typeName.startsWith("Bytes")) {
                Class<?> c = Class.forName("org.nervos.appchain.abi.datatypes.generated." + typeName);
                ctor = c.getDeclaredConstructor(byte[].class);
            } else {
                throw new InvalidAbiType(typeName);
            }
            return (Type)ctor.newInstance(value);
        }

        public Object abiToJava(Type value) {
            if (this.rawType != null) {
                ArrayList result = new ArrayList();
                List list = (List)value.getValue();
                list.forEach(type -> result.add(type.getValue()));
                return result;
            }
            return value.getValue();
        }

        public TypeReference getTypeReference() {
            if (this.rawType != null) {
                ParameterizedType parameterizedType = new ParameterizedType(){

                    @Override
                    public java.lang.reflect.Type[] getActualTypeArguments() {
                        return new java.lang.reflect.Type[]{baseType};
                    }

                    @Override
                    public java.lang.reflect.Type getRawType() {
                        return rawType;
                    }

                    @Override
                    public java.lang.reflect.Type getOwnerType() {
                        return null;
                    }
                };
                if (StaticArray.class.isAssignableFrom(this.rawType)) {
                    String typeName = this.rawType.getSimpleName();
                    String baseTypeName = "StaticArray";
                    String length = typeName.substring(baseTypeName.length());
                    return TypeReference.create((int)Integer.parseInt(length), (ParameterizedType)parameterizedType);
                }
                return TypeReference.create((ParameterizedType)parameterizedType);
            }
            return TypeReference.create(this.baseType);
        }
    }

    public static class InvalidAbiType
    extends Exception {
        private String invalidTypeName;

        public InvalidAbiType(String name) {
            this.invalidTypeName = name;
        }

        @Override
        public String toString() {
            return "Invalid ABI type: " + this.invalidTypeName;
        }
    }
}

