/*
 * Decompiled with CFR 0.152.
 */
package org.abstractj.kalium;

import jnr.ffi.LibraryLoader;
import jnr.ffi.Platform;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;
import jnr.ffi.byref.LongLongByReference;
import jnr.ffi.types.u_int64_t;

public class NaCl {
    private static final String LIBRARY_NAME = NaCl.libraryName();
    public static final Integer[] MIN_SUPPORTED_VERSION = new Integer[]{1, 0, 3};
    private static boolean versionSupported = false;

    public static Sodium sodium() {
        Sodium sodium = SingletonHolder.SODIUM_INSTANCE;
        NaCl.checkVersion(sodium);
        return sodium;
    }

    private static String libraryName() {
        switch (Platform.getNativePlatform().getOS()) {
            case WINDOWS: {
                return "libsodium";
            }
        }
        return "sodium";
    }

    private static final void checkVersion(Sodium lib) {
        if (!versionSupported) {
            String[] version = lib.sodium_version_string().split("\\.");
            boolean bl = versionSupported = version.length >= 3 && MIN_SUPPORTED_VERSION[0] <= new Integer(version[0]) && MIN_SUPPORTED_VERSION[1] <= new Integer(version[1]) && MIN_SUPPORTED_VERSION[2] <= new Integer(version[2]);
        }
        if (!versionSupported) {
            String message = String.format("Unsupported libsodium version: %s. Please update", lib.sodium_version_string());
            throw new UnsupportedOperationException(message);
        }
    }

    private NaCl() {
    }

    public static synchronized int init() {
        return NaCl.sodium().sodium_init();
    }

    static /* synthetic */ String access$000() {
        return LIBRARY_NAME;
    }

    public static interface Sodium {
        @Deprecated
        public static final int XSALSA20_POLY1305_SECRETBOX_KEYBYTES = 32;
        @Deprecated
        public static final int XSALSA20_POLY1305_SECRETBOX_NONCEBYTES = 24;
        public static final int CRYPTO_SECRETBOX_XSALSA20POLY1305_KEYBYTES = 32;
        public static final int CRYPTO_SECRETBOX_XSALSA20POLY1305_NONCEBYTES = 24;
        @Deprecated
        public static final int HMACSHA512256_BYTES = 32;
        @Deprecated
        public static final int HMACSHA512256_KEYBYTES = 32;
        public static final int CRYPTO_AUTH_HMACSHA512256_BYTES = 32;
        public static final int CRYPTO_AUTH_HMACSHA512256_KEYBYTES = 32;
        public static final int CRYPTO_AEAD_CHACHA20POLY1305_KEYBYTES = 32;
        public static final int CRYPTO_AEAD_CHACHA20POLY1305_NPUBBYTES = 8;
        public static final int CRYPTO_AEAD_CHACHA20POLY1305_ABYTES = 16;
        @Deprecated
        public static final int PUBLICKEY_BYTES = 32;
        @Deprecated
        public static final int SECRETKEY_BYTES = 32;
        @Deprecated
        public static final int NONCE_BYTES = 24;
        @Deprecated
        public static final int ZERO_BYTES = 32;
        @Deprecated
        public static final int BOXZERO_BYTES = 16;
        public static final int CRYPTO_BOX_CURVE25519XSALSA20POLY1305_PUBLICKEYBYTES = 32;
        public static final int CRYPTO_BOX_CURVE25519XSALSA20POLY1305_SECRETKEYBYTES = 32;
        public static final int CRYPTO_BOX_CURVE25519XSALSA20POLY1305_ZEROBYTES = 32;
        public static final int CRYPTO_BOX_CURVE25519XSALSA20POLY1305_BOXZEROBYTES = 16;
        public static final int CRYPTO_BOX_CURVE25519XSALSA20POLY1305_MACBYTES = 16;
        public static final int CRYPTO_BOX_CURVE25519XSALSA20POLY1305_NONCEBYTES = 24;
        public static final int CRYPTO_BOX_CURVE25519XSALSA20POLY1305_BEFORENMBYTES = 32;
        @Deprecated
        public static final int SIGNATURE_BYTES = 64;
        public static final int CRYPTO_SIGN_ED25519_PUBLICKEYBYTES = 32;
        public static final int CRYPTO_SIGN_ED25519_SECRETKEYBYTES = 64;
        public static final int CRYPTO_SIGN_ED25519_BYTES = 64;
        public static final int CRYPTO_BOX_SEALBYTES = 48;
        @Deprecated
        public static final int BLAKE2B_OUTBYTES = 64;
        public static final int CRYPTO_GENERICHASH_BLAKE2B_BYTES = 32;
        public static final int CRYPTO_GENERICHASH_BLAKE2B_BYTES_MIN = 16;
        public static final int CRYPTO_GENERICHASH_BLAKE2B_BYTES_MAX = 64;
        public static final int CRYPTO_GENERICHASH_BLAKE2B_KEYBYTES = 32;
        public static final int CRYPTO_GENERICHASH_BLAKE2B_KEYBYTES_MIN = 16;
        public static final int CRYPTO_GENERICHASH_BLAKE2B_KEYBYTES_MAX = 64;
        @Deprecated
        public static final int PWHASH_SCRYPTSALSA208SHA256_STRBYTES = 102;
        @Deprecated
        public static final int PWHASH_SCRYPTSALSA208SHA256_OUTBYTES = 64;
        @Deprecated
        public static final int PWHASH_SCRYPTSALSA208SHA256_OPSLIMIT_INTERACTIVE = 524288;
        @Deprecated
        public static final int PWHASH_SCRYPTSALSA208SHA256_MEMLIMIT_INTERACTIVE = 0x1000000;
        public static final int CRYPTO_PWHASH_SCRYPTSALSA208SHA256_STRBYTES = 102;
        public static final int CRYPTO_PWHASH_SCRYPTSALSA208SHA256_OUTBYTES = 64;
        public static final int CRYPTO_PWHASH_SCRYPTSALSA208SHA256_OPSLIMIT_INTERACTIVE = 524288;
        public static final int CRYPTO_PWHASH_SCRYPTSALSA208SHA256_MEMLIMIT_INTERACTIVE = 0x1000000;
        public static final int CRYPTO_AEAD_AES256GCM_KEYBYTES = 32;
        public static final int CRYPTO_AEAD_AES256GCM_NPUBBYTES = 12;
        public static final int CRYPTO_AEAD_AES256GCM_ABYTES = 16;
        public static final int SHA256BYTES = 32;
        public static final int SHA512BYTES = 64;
        public static final int CRYPTO_HASH_SHA256_BYTES = 32;
        public static final int CRYPTO_HASH_SHA512_BYTES = 64;
        public static final int CRYPTO_SCALARMULT_CURVE25519_SCALARBYTES = 32;
        public static final int CRYPTO_SCALARMULT_CURVE25519_BYTES = 32;
        public static final int CRYPTO_STREAM_KEYBYTES = 32;
        public static final int CRYPTO_STREAM_NONCEBYTES = 24;

        public int sodium_init();

        public String sodium_version_string();

        public void randombytes(@Out byte[] var1, @In @u_int64_t int var2);

        public int crypto_secretbox_xsalsa20poly1305(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3, @In byte[] var4, @In byte[] var5);

        public int crypto_secretbox_xsalsa20poly1305_open(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3, @In byte[] var4, @In byte[] var5);

        public int crypto_auth_hmacsha512256(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3, @In byte[] var4);

        public int crypto_auth_hmacsha512256_verify(@In byte[] var1, @In byte[] var2, @In @u_int64_t int var3, @In byte[] var4);

        public int crypto_aead_chacha20poly1305_encrypt(@Out byte[] var1, @Out LongLongByReference var2, @In byte[] var3, @In @u_int64_t int var4, @In byte[] var5, @In @u_int64_t int var6, @In byte[] var7, @In byte[] var8, @In byte[] var9);

        public int crypto_aead_chacha20poly1305_decrypt(@Out byte[] var1, @Out LongLongByReference var2, @In byte[] var3, @In byte[] var4, @In @u_int64_t int var5, @In byte[] var6, @In @u_int64_t int var7, @In byte[] var8, @In byte[] var9);

        public int crypto_box_curve25519xsalsa20poly1305_keypair(@Out byte[] var1, @Out byte[] var2);

        public int crypto_box_curve25519xsalsa20poly1305_beforenm(@Out byte[] var1, @In byte[] var2, @In byte[] var3);

        public int crypto_box_curve25519xsalsa20poly1305(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3, @In byte[] var4, @In byte[] var5, @In byte[] var6);

        public int crypto_box_curve25519xsalsa20poly1305_afternm(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3, @In byte[] var4, @In byte[] var5);

        public int crypto_box_curve25519xsalsa20poly1305_open(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3, @In byte[] var4, @In byte[] var5, @In byte[] var6);

        public int crypto_box_curve25519xsalsa20poly1305_open_afternm(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3, @In byte[] var4, @In byte[] var5);

        public int crypto_sign_ed25519_seed_keypair(@Out byte[] var1, @Out byte[] var2, @In byte[] var3);

        public int crypto_sign_ed25519(@Out byte[] var1, @Out LongLongByReference var2, @In byte[] var3, @In @u_int64_t int var4, @In byte[] var5);

        public int crypto_sign_ed25519_open(@Out byte[] var1, @Out LongLongByReference var2, @In byte[] var3, @In @u_int64_t int var4, @In byte[] var5);

        public int crypto_box_seal(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3, @In byte[] var4);

        public int crypto_box_seal_open(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3, @In byte[] var4, @In byte[] var5);

        public int crypto_generichash_blake2b(@Out byte[] var1, @In @u_int64_t int var2, @In byte[] var3, @u_int64_t int var4, @In byte[] var5, @In @u_int64_t int var6);

        public int crypto_generichash_blake2b_salt_personal(@Out byte[] var1, @In @u_int64_t int var2, @In byte[] var3, @u_int64_t int var4, @In byte[] var5, @In @u_int64_t int var6, @In byte[] var7, @In byte[] var8);

        public int crypto_pwhash_scryptsalsa208sha256(@Out byte[] var1, @In @u_int64_t int var2, @In byte[] var3, @In @u_int64_t int var4, @In byte[] var5, @In @u_int64_t long var6, @In @u_int64_t long var8);

        public int crypto_pwhash_scryptsalsa208sha256_str(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3, @In @u_int64_t long var4, @In @u_int64_t long var6);

        public int crypto_pwhash_scryptsalsa208sha256_str_verify(@In byte[] var1, @In byte[] var2, @In @u_int64_t int var3);

        public int crypto_aead_aes256gcm_is_available();

        public int crypto_aead_aes256gcm_encrypt(@Out byte[] var1, @Out LongLongByReference var2, @In byte[] var3, @In @u_int64_t int var4, @In byte[] var5, @In @u_int64_t int var6, @In byte[] var7, @In byte[] var8, @In byte[] var9);

        public int crypto_aead_aes256gcm_decrypt(@Out byte[] var1, @Out LongLongByReference var2, @In byte[] var3, @In byte[] var4, @In @u_int64_t int var5, @In byte[] var6, @In @u_int64_t int var7, @In byte[] var8, @In byte[] var9);

        public int crypto_aead_aes256gcm_statebytes();

        public int crypto_aead_aes256gcm_beforenm(@Out byte[] var1, @In byte[] var2);

        public int crypto_aead_aes256gcm_encrypt_afternm(@Out byte[] var1, @Out LongLongByReference var2, @In byte[] var3, @In @u_int64_t int var4, @In byte[] var5, @In @u_int64_t int var6, @In byte[] var7, @In byte[] var8, @In @Out byte[] var9);

        public int crypto_aead_aes256gcm_decrypt_afternm(@Out byte[] var1, @Out LongLongByReference var2, @In byte[] var3, @In @u_int64_t int var4, @In byte[] var5, @In @u_int64_t int var6, @In byte[] var7, @In byte[] var8, @In @Out byte[] var9);

        public int crypto_hash_sha256(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3);

        public int crypto_hash_sha512(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3);

        public int crypto_scalarmult_curve25519(@Out byte[] var1, @In byte[] var2, @In byte[] var3);

        public int crypto_stream_xor(@Out byte[] var1, @In byte[] var2, @In @u_int64_t int var3, @In byte[] var4, @In byte[] var5);
    }

    private static final class SingletonHolder {
        public static final Sodium SODIUM_INSTANCE = (Sodium)LibraryLoader.create(Sodium.class).search("/usr/local/lib").search("/opt/local/lib").search("lib").load(NaCl.access$000());

        private SingletonHolder() {
        }
    }
}

