/*
 * Decompiled with CFR 0.152.
 */
package org.abstractj.kalium.keys;

import org.abstractj.kalium.NaCl;
import org.abstractj.kalium.crypto.Util;
import org.abstractj.kalium.encoders.Encoder;
import org.abstractj.kalium.keys.Key;

public class AuthenticationKey
implements Key {
    private byte[] key;

    public AuthenticationKey(byte[] key) {
        this.key = key;
        Util.checkLength(key, 32);
    }

    public AuthenticationKey(String key, Encoder encoder) {
        this(encoder.decode(key));
    }

    public byte[] sign(byte[] message) {
        byte[] mac = new byte[32];
        NaCl.sodium().crypto_auth_hmacsha512256(mac, message, message.length, this.key);
        return mac;
    }

    public String sign(String message, Encoder encoder) {
        byte[] signature = this.sign(encoder.decode(message));
        return encoder.encode(signature);
    }

    public boolean verify(byte[] message, byte[] signature) {
        Util.checkLength(signature, 32);
        return Util.isValid(NaCl.sodium().crypto_auth_hmacsha512256_verify(signature, message, message.length, this.key), "signature was forged or corrupted");
    }

    public boolean verify(String message, String signature, Encoder encoder) {
        return this.verify(encoder.decode(message), encoder.decode(signature));
    }

    @Override
    public byte[] toBytes() {
        return this.key;
    }

    public String toString() {
        return Encoder.HEX.encode(this.key);
    }
}

