/*
 * Decompiled with CFR 0.152.
 */
package org.abstractj.kalium.keys;

import org.abstractj.kalium.crypto.Util;
import org.abstractj.kalium.encoders.Encoder;
import org.abstractj.kalium.keys.Key;

public class PrivateKey
implements Key {
    private final byte[] secretKey;

    public PrivateKey(byte[] secretKey) {
        this.secretKey = secretKey;
        Util.checkLength(secretKey, 32);
    }

    public PrivateKey(String secretKey) {
        this.secretKey = Encoder.HEX.decode(secretKey);
        Util.checkLength(this.secretKey, 32);
    }

    @Override
    public byte[] toBytes() {
        return this.secretKey;
    }

    public String toString() {
        return Encoder.HEX.encode(this.secretKey);
    }
}

