/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.codegen;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.lang.model.element.Modifier;
import org.nervos.appchain.abi.EventEncoder;
import org.nervos.appchain.abi.EventValues;
import org.nervos.appchain.abi.FunctionEncoder;
import org.nervos.appchain.abi.TypeReference;
import org.nervos.appchain.abi.datatypes.Address;
import org.nervos.appchain.abi.datatypes.Bool;
import org.nervos.appchain.abi.datatypes.DynamicArray;
import org.nervos.appchain.abi.datatypes.DynamicBytes;
import org.nervos.appchain.abi.datatypes.Event;
import org.nervos.appchain.abi.datatypes.Function;
import org.nervos.appchain.abi.datatypes.StaticArray;
import org.nervos.appchain.abi.datatypes.Type;
import org.nervos.appchain.abi.datatypes.Utf8String;
import org.nervos.appchain.abi.datatypes.generated.AbiTypes;
import org.nervos.appchain.codegen.Generator;
import org.nervos.appchain.protocol.Nervosj;
import org.nervos.appchain.protocol.ObjectMapperFactory;
import org.nervos.appchain.protocol.core.DefaultBlockParameter;
import org.nervos.appchain.protocol.core.RemoteCall;
import org.nervos.appchain.protocol.core.methods.request.AppFilter;
import org.nervos.appchain.protocol.core.methods.response.AbiDefinition;
import org.nervos.appchain.protocol.core.methods.response.Log;
import org.nervos.appchain.protocol.core.methods.response.TransactionReceipt;
import org.nervos.appchain.tx.Contract;
import org.nervos.appchain.tx.TransactionManager;
import org.nervos.appchain.utils.Collection;
import org.nervos.appchain.utils.Strings;
import org.nervos.appchain.utils.Version;
import rx.Observable;
import rx.functions.Func1;

public class SolidityFunctionWrapper
extends Generator {
    private static final String BINARY = "BINARY";
    private static final String NERVOSJ = "nervosj";
    private static final String CREDENTIALS = "credentials";
    private static final String TRANSACTION_MANAGER = "transactionManager";
    private static final String INITIAL_VALUE = "initialWeiValue";
    private static final String CONTRACT_ADDRESS = "contractAddress";
    private static final String GAS_PRICE = "gasPrice";
    private static final String GAS_LIMIT = "gasLimit";
    private static final String START_BLOCK = "startBlock";
    private static final String END_BLOCK = "endBlock";
    private static final String WEI_VALUE = "weiValue";
    private static final String QUOTA = "quota";
    private static final String NONCE = "nonce";
    private static final String VALID_UNTIL_BLOCK = "validUntilBlock";
    private static final String VERSION = "version";
    private static final String CHAIN_ID = "chainId";
    private static final String VALUE = "value";
    private static final String CODEGEN_WARNING = "<p>Auto generated code.\n<p><strong>Do not modify!</strong>\n<p>Please use the <a href=\"https://github.com/cryptape/nervosj/tree/master/codegen\">codegen module</a> to update.\n";
    private final boolean useNativeJavaTypes;

    public SolidityFunctionWrapper(boolean useNativeJavaTypes) {
        this.useNativeJavaTypes = useNativeJavaTypes;
    }

    public void generateJavaFiles(String contractName, String bin, String abi, String destinationDir, String basePackageName) throws IOException, ClassNotFoundException {
        this.generateJavaFiles(contractName, bin, this.loadContractDefinition(abi), destinationDir, basePackageName, null);
    }

    void generateJavaFiles(String contractName, String bin, List<AbiDefinition> abi, String destinationDir, String basePackageName, Map<String, String> addresses) throws IOException, ClassNotFoundException {
        String className = Strings.capitaliseFirstLetter((String)contractName);
        TypeSpec.Builder classBuilder = this.createClassBuilder(className, bin);
        classBuilder.addMethod(SolidityFunctionWrapper.buildConstructorAdaptToCita(TransactionManager.class, TRANSACTION_MANAGER));
        classBuilder.addMethods(this.buildFunctionDefinitions(className, classBuilder, abi));
        classBuilder.addMethod(SolidityFunctionWrapper.buildLoadAdaptToCita(className, TransactionManager.class, TRANSACTION_MANAGER));
        this.addAddressesSupport(classBuilder, addresses);
        this.write(basePackageName, classBuilder.build(), destinationDir);
    }

    private void addAddressesSupport(TypeSpec.Builder classBuilder, Map<String, String> addresses) {
        if (addresses != null) {
            ClassName stringType = ClassName.get(String.class);
            ClassName mapType = ClassName.get(HashMap.class);
            ParameterizedTypeName mapStringString = ParameterizedTypeName.get((ClassName)mapType, (TypeName[])new TypeName[]{stringType, stringType});
            FieldSpec addressesStaticField = FieldSpec.builder((TypeName)mapStringString, (String)"_addresses", (Modifier[])new Modifier[]{Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL}).build();
            classBuilder.addField(addressesStaticField);
            CodeBlock.Builder staticInit = CodeBlock.builder();
            staticInit.addStatement("_addresses = new HashMap<>()", new Object[0]);
            addresses.forEach((k, v) -> staticInit.addStatement(String.format("_addresses.put(\"%1s\", \"%2s\")", k, v), new Object[0]));
            classBuilder.addStaticBlock(staticInit.build());
            MethodSpec getAddress = MethodSpec.methodBuilder((String)"getStaticDeployedAddress").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)stringType).addParameter((TypeName)stringType, "networkId", new Modifier[0]).addCode(CodeBlock.builder().addStatement("return _addresses.get(networkId)", new Object[0]).build()).build();
            classBuilder.addMethod(getAddress);
            MethodSpec getPreviousAddress = MethodSpec.methodBuilder((String)"getPreviouslyDeployedAddress").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)stringType).addParameter((TypeName)stringType, "networkId", new Modifier[0]).addCode(CodeBlock.builder().addStatement("return _addresses.get(networkId)", new Object[0]).build()).build();
            classBuilder.addMethod(getPreviousAddress);
        }
    }

    private TypeSpec.Builder createClassBuilder(String className, String binary) {
        String javadoc = CODEGEN_WARNING + this.getWeb3jVersion();
        return TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(javadoc, new Object[0]).superclass(Contract.class).addField(this.createBinaryDefinition(binary));
    }

    private String getWeb3jVersion() {
        String version;
        try {
            version = Version.getVersion();
        }
        catch (IOException | NullPointerException e) {
            version = "none";
        }
        return "\n<p>Generated with nervosj version " + version + ".\n";
    }

    private FieldSpec createBinaryDefinition(String binary) {
        return FieldSpec.builder(String.class, (String)BINARY, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{binary}).build();
    }

    private List<MethodSpec> buildFunctionDefinitions(String className, TypeSpec.Builder classBuilder, List<AbiDefinition> functionDefinitions) throws ClassNotFoundException {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        boolean constructor = false;
        for (AbiDefinition functionDefinition : functionDefinitions) {
            if (functionDefinition.getType().equals("function")) {
                methodSpecs.add(this.buildFunction(functionDefinition));
                continue;
            }
            if (functionDefinition.getType().equals("event")) {
                this.buildEventFunctions(functionDefinition, classBuilder);
                continue;
            }
            if (!functionDefinition.getType().equals("constructor")) continue;
            constructor = true;
            methodSpecs.add(this.buildDeployAdaptToCita(className, functionDefinition, TransactionManager.class, TRANSACTION_MANAGER));
        }
        if (!constructor) {
            MethodSpec.Builder txManagerMethodBuilderAdapter = SolidityFunctionWrapper.getDeployMethodSpec(className, TransactionManager.class, TRANSACTION_MANAGER);
            methodSpecs.add(SolidityFunctionWrapper.buildDeployNoParams(txManagerMethodBuilderAdapter, className, TRANSACTION_MANAGER));
        }
        return methodSpecs;
    }

    private static MethodSpec buildConstructor(Class authType, String authName) {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(String.class, CONTRACT_ADDRESS, new Modifier[0]).addParameter(Nervosj.class, NERVOSJ, new Modifier[0]).addParameter((java.lang.reflect.Type)authType, authName, new Modifier[0]).addParameter(BigInteger.class, GAS_PRICE, new Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new Modifier[0]).addStatement("super($N, $N, $N, $N, $N, $N)", new Object[]{BINARY, CONTRACT_ADDRESS, NERVOSJ, authName, GAS_PRICE, GAS_LIMIT}).build();
    }

    private static MethodSpec buildConstructorAdaptToCita(Class authType, String authName) {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter(String.class, CONTRACT_ADDRESS, new Modifier[0]).addParameter(Nervosj.class, NERVOSJ, new Modifier[0]).addParameter((java.lang.reflect.Type)authType, authName, new Modifier[0]).addStatement("super($N, $N, $N, $N)", new Object[]{BINARY, CONTRACT_ADDRESS, NERVOSJ, authName}).build();
    }

    private MethodSpec buildDeploy(String className, AbiDefinition functionDefinition, Class authType, String authName) {
        boolean isPayable = functionDefinition.isPayable();
        MethodSpec.Builder methodBuilder = SolidityFunctionWrapper.getDeployMethodSpec(className, authType, authName, isPayable);
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        if (!inputParams.isEmpty()) {
            return SolidityFunctionWrapper.buildDeployWithParams(methodBuilder, className, inputParams, authName, isPayable);
        }
        return SolidityFunctionWrapper.buildDeployNoParams(methodBuilder, className, authName, isPayable);
    }

    private MethodSpec buildDeployAdaptToCita(String className, AbiDefinition functionDefinition, Class authType, String authName) {
        MethodSpec.Builder methodBuilder = SolidityFunctionWrapper.getDeployMethodSpec(className, authType, authName);
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        if (!inputParams.isEmpty()) {
            return SolidityFunctionWrapper.buildDeployWithParams(methodBuilder, className, inputParams, authName);
        }
        return SolidityFunctionWrapper.buildDeployNoParams(methodBuilder, className, authName);
    }

    private static MethodSpec buildDeployWithParams(MethodSpec.Builder methodBuilder, String className, String inputParams, String authName, boolean isPayable) {
        methodBuilder.addStatement("$T encodedConstructor = $T.encodeConstructor($T.<$T>asList($L))", new Object[]{String.class, FunctionEncoder.class, Arrays.class, Type.class, inputParams});
        if (isPayable) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, encodedConstructor, $L)", new Object[]{className, NERVOSJ, authName, GAS_PRICE, GAS_LIMIT, BINARY, INITIAL_VALUE});
        } else {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, encodedConstructor)", new Object[]{className, NERVOSJ, authName, GAS_PRICE, GAS_LIMIT, BINARY});
        }
        return methodBuilder.build();
    }

    private static MethodSpec buildDeployWithParams(MethodSpec.Builder methodBuilder, String className, String inputParams, String authName) {
        methodBuilder.addStatement("$T encodedConstructor = $T.encodeConstructor($T.<$T>asList($L))", new Object[]{String.class, FunctionEncoder.class, Arrays.class, Type.class, inputParams});
        methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, $L, $L, $L, $L, encodedConstructor)", new Object[]{className, NERVOSJ, authName, QUOTA, NONCE, VALID_UNTIL_BLOCK, VERSION, CHAIN_ID, VALUE, BINARY});
        return methodBuilder.build();
    }

    private static MethodSpec buildDeployNoParams(MethodSpec.Builder methodBuilder, String className, String authName, boolean isPayable) {
        if (isPayable) {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, \"\", $L)", new Object[]{className, NERVOSJ, authName, GAS_PRICE, GAS_LIMIT, BINARY, INITIAL_VALUE});
        } else {
            methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, \"\")", new Object[]{className, NERVOSJ, authName, GAS_PRICE, GAS_LIMIT, BINARY});
        }
        return methodBuilder.build();
    }

    private static MethodSpec buildDeployNoParams(MethodSpec.Builder methodBuilder, String className, String authName) {
        methodBuilder.addStatement("return deployRemoteCall($L.class, $L, $L, $L, $L, $L, $L, $L, $L, $L, \"\")", new Object[]{className, NERVOSJ, authName, QUOTA, NONCE, VALID_UNTIL_BLOCK, VERSION, CHAIN_ID, VALUE, BINARY});
        return methodBuilder.build();
    }

    private static MethodSpec.Builder getDeployMethodSpec(String className, Class authType, String authName, boolean isPayable) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"deploy").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)SolidityFunctionWrapper.buildRemoteCall((TypeName)TypeVariableName.get((String)className, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{Type.class}))).addParameter(Nervosj.class, NERVOSJ, new Modifier[0]).addParameter((java.lang.reflect.Type)authType, authName, new Modifier[0]).addParameter(BigInteger.class, GAS_PRICE, new Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new Modifier[0]);
        if (isPayable) {
            return builder.addParameter(BigInteger.class, INITIAL_VALUE, new Modifier[0]);
        }
        return builder;
    }

    private static MethodSpec.Builder getDeployMethodSpec(String className, Class authType, String authName) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"deploy").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)SolidityFunctionWrapper.buildRemoteCall((TypeName)TypeVariableName.get((String)className, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{Type.class}))).addParameter(Nervosj.class, NERVOSJ, new Modifier[0]).addParameter((java.lang.reflect.Type)authType, authName, new Modifier[0]).addParameter(Long.class, QUOTA, new Modifier[0]).addParameter(BigInteger.class, NONCE, new Modifier[0]).addParameter(Long.class, VALID_UNTIL_BLOCK, new Modifier[0]).addParameter(Integer.class, VERSION, new Modifier[0]).addParameter(String.class, VALUE, new Modifier[0]).addParameter(Integer.class, CHAIN_ID, new Modifier[0]);
        return builder;
    }

    private static MethodSpec buildLoad(String className, Class authType, String authName) {
        return MethodSpec.methodBuilder((String)"load").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)TypeVariableName.get((String)className, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{Type.class})).addParameter(String.class, CONTRACT_ADDRESS, new Modifier[0]).addParameter(Nervosj.class, NERVOSJ, new Modifier[0]).addParameter((java.lang.reflect.Type)authType, authName, new Modifier[0]).addParameter(BigInteger.class, GAS_PRICE, new Modifier[0]).addParameter(BigInteger.class, GAS_LIMIT, new Modifier[0]).addStatement("return new $L($L, $L, $L, $L, $L)", new Object[]{className, CONTRACT_ADDRESS, NERVOSJ, authName, GAS_PRICE, GAS_LIMIT}).build();
    }

    private static MethodSpec buildLoadAdaptToCita(String className, Class authType, String authName) {
        return MethodSpec.methodBuilder((String)"load").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)TypeVariableName.get((String)className, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{Type.class})).addParameter(String.class, CONTRACT_ADDRESS, new Modifier[0]).addParameter(Nervosj.class, NERVOSJ, new Modifier[0]).addParameter((java.lang.reflect.Type)authType, authName, new Modifier[0]).addStatement("return new $L($L, $L, $L)", new Object[]{className, CONTRACT_ADDRESS, NERVOSJ, authName}).build();
    }

    String addParameters(MethodSpec.Builder methodBuilder, List<AbiDefinition.NamedType> namedTypes) {
        List<ParameterSpec> inputParameterTypes = SolidityFunctionWrapper.buildParameterTypes(namedTypes);
        ArrayList<ParameterSpec> nativeInputParameterTypes = new ArrayList<ParameterSpec>(inputParameterTypes.size());
        for (ParameterSpec parameterSpec2 : inputParameterTypes) {
            TypeName typeName = this.getWrapperType(parameterSpec2.type);
            nativeInputParameterTypes.add(ParameterSpec.builder((TypeName)typeName, (String)parameterSpec2.name, (Modifier[])new Modifier[0]).build());
        }
        methodBuilder.addParameters(nativeInputParameterTypes);
        if (this.useNativeJavaTypes) {
            return Collection.join(inputParameterTypes, (String)", \n", parameterSpec -> this.createMappedParameterTypes((ParameterSpec)parameterSpec));
        }
        return Collection.join(inputParameterTypes, (String)", ", parameterSpec -> parameterSpec.name);
    }

    private String createMappedParameterTypes(ParameterSpec parameterSpec) {
        if (parameterSpec.type instanceof ParameterizedTypeName) {
            List typeNames = ((ParameterizedTypeName)parameterSpec.type).typeArguments;
            if (typeNames.size() != 1) {
                throw new UnsupportedOperationException("Only a single parameterized type is supported");
            }
            TypeName typeName = (TypeName)typeNames.get(0);
            return "new " + parameterSpec.type + "(\n        org.nervos.appchain.abi.Utils.typeMap(" + parameterSpec.name + ", " + typeName + ".class))";
        }
        return "new " + parameterSpec.type + "(" + parameterSpec.name + ")";
    }

    private TypeName getWrapperType(TypeName typeName) {
        if (this.useNativeJavaTypes) {
            return SolidityFunctionWrapper.getNativeType(typeName);
        }
        return typeName;
    }

    private TypeName getWrapperRawType(TypeName typeName) {
        if (this.useNativeJavaTypes) {
            if (typeName instanceof ParameterizedTypeName) {
                return ClassName.get(List.class);
            }
            return SolidityFunctionWrapper.getNativeType(typeName);
        }
        return typeName;
    }

    private TypeName getIndexedEventWrapperType(TypeName typeName) {
        if (this.useNativeJavaTypes) {
            return SolidityFunctionWrapper.getEventNativeType(typeName);
        }
        return typeName;
    }

    static TypeName getNativeType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return SolidityFunctionWrapper.getNativeType((ParameterizedTypeName)typeName);
        }
        String simpleName = ((ClassName)typeName).simpleName();
        if (simpleName.equals(Address.class.getSimpleName())) {
            return TypeName.get(String.class);
        }
        if (simpleName.startsWith("Uint")) {
            return TypeName.get(BigInteger.class);
        }
        if (simpleName.startsWith("Int")) {
            return TypeName.get(BigInteger.class);
        }
        if (simpleName.equals(Utf8String.class.getSimpleName())) {
            return TypeName.get(String.class);
        }
        if (simpleName.startsWith("Bytes")) {
            return TypeName.get(byte[].class);
        }
        if (simpleName.equals(DynamicBytes.class.getSimpleName())) {
            return TypeName.get(byte[].class);
        }
        if (simpleName.equals(Bool.class.getSimpleName())) {
            return TypeName.get(Boolean.class);
        }
        throw new UnsupportedOperationException("Unsupported type: " + typeName + ", no native type mapping exists.");
    }

    static TypeName getNativeType(ParameterizedTypeName parameterizedTypeName) {
        List typeNames = parameterizedTypeName.typeArguments;
        ArrayList<TypeName> nativeTypeNames = new ArrayList<TypeName>(typeNames.size());
        for (TypeName enclosedTypeName : typeNames) {
            nativeTypeNames.add(SolidityFunctionWrapper.getNativeType(enclosedTypeName));
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])nativeTypeNames.toArray(new TypeName[nativeTypeNames.size()]));
    }

    static TypeName getEventNativeType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return TypeName.get(byte[].class);
        }
        String simpleName = ((ClassName)typeName).simpleName();
        if (simpleName.equals(Utf8String.class.getSimpleName())) {
            return TypeName.get(byte[].class);
        }
        return SolidityFunctionWrapper.getNativeType(typeName);
    }

    static List<ParameterSpec> buildParameterTypes(List<AbiDefinition.NamedType> namedTypes) {
        ArrayList<ParameterSpec> result = new ArrayList<ParameterSpec>(namedTypes.size());
        for (int i = 0; i < namedTypes.size(); ++i) {
            AbiDefinition.NamedType namedType = namedTypes.get(i);
            String name = SolidityFunctionWrapper.createValidParamName(namedType.getName(), i);
            String type = namedTypes.get(i).getType();
            result.add(ParameterSpec.builder((TypeName)SolidityFunctionWrapper.buildTypeName(type), (String)name, (Modifier[])new Modifier[0]).build());
        }
        return result;
    }

    static String createValidParamName(String name, int idx) {
        if (name.equals("")) {
            return "param" + idx;
        }
        return name;
    }

    static List<TypeName> buildTypeNames(List<AbiDefinition.NamedType> namedTypes) {
        ArrayList<TypeName> result = new ArrayList<TypeName>(namedTypes.size());
        for (AbiDefinition.NamedType namedType : namedTypes) {
            result.add(SolidityFunctionWrapper.buildTypeName(namedType.getType()));
        }
        return result;
    }

    MethodSpec buildFunction(AbiDefinition functionDefinition) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)functionName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        String inputParams = this.addParameters(methodBuilder, functionDefinition.getInputs());
        List<TypeName> outputParameterTypes = SolidityFunctionWrapper.buildTypeNames(functionDefinition.getOutputs());
        if (functionDefinition.isConstant()) {
            this.buildConstantFunction(functionDefinition, methodBuilder, outputParameterTypes, inputParams);
        } else {
            SolidityFunctionWrapper.buildTransactionFunction(functionDefinition, methodBuilder, inputParams);
        }
        return methodBuilder.build();
    }

    private void buildConstantFunction(AbiDefinition functionDefinition, MethodSpec.Builder methodBuilder, List<TypeName> outputParameterTypes, String inputParams) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        if (outputParameterTypes.isEmpty()) {
            throw new RuntimeException("Only transactional methods should have void return types");
        }
        if (outputParameterTypes.size() == 1) {
            TypeName typeName = outputParameterTypes.get(0);
            TypeName nativeReturnTypeName = this.useNativeJavaTypes ? this.getWrapperRawType(typeName) : this.getWrapperType(typeName);
            methodBuilder.returns((TypeName)SolidityFunctionWrapper.buildRemoteCall(nativeReturnTypeName));
            methodBuilder.addStatement("$T function = new $T($S, \n$T.<$T>asList($L), \n$T.<$T<?>>asList(new $T<$T>() {}))", new Object[]{Function.class, Function.class, functionName, Arrays.class, Type.class, inputParams, Arrays.class, TypeReference.class, TypeReference.class, typeName});
            if (this.useNativeJavaTypes) {
                methodBuilder.addStatement("return executeRemoteCallSingleValueReturn(function, $T.class)", new Object[]{nativeReturnTypeName});
            } else {
                methodBuilder.addStatement("return executeRemoteCallSingleValueReturn(function)", new Object[0]);
            }
        } else {
            List<TypeName> returnTypes = this.buildReturnTypes(outputParameterTypes);
            ParameterizedTypeName parameterizedTupleType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"org.nervos.appchain.tuples.generated", (String)("Tuple" + returnTypes.size()), (String[])new String[0]), (TypeName[])returnTypes.toArray(new TypeName[returnTypes.size()]));
            methodBuilder.returns((TypeName)SolidityFunctionWrapper.buildRemoteCall((TypeName)parameterizedTupleType));
            SolidityFunctionWrapper.buildVariableLengthReturnFunctionConstructor(methodBuilder, functionName, inputParams, outputParameterTypes);
            this.buildTupleResultContainer(methodBuilder, parameterizedTupleType, outputParameterTypes);
        }
    }

    private static ParameterizedTypeName buildRemoteCall(TypeName typeName) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(RemoteCall.class), (TypeName[])new TypeName[]{typeName});
    }

    private static void buildTransactionFunction(AbiDefinition functionDefinition, MethodSpec.Builder methodBuilder, String inputParams) throws ClassNotFoundException {
        if (functionDefinition.isPayable()) {
            methodBuilder.addParameter(BigInteger.class, WEI_VALUE, new Modifier[0]);
        }
        methodBuilder.addParameter(Long.class, QUOTA, new Modifier[0]).addParameter(BigInteger.class, NONCE, new Modifier[0]).addParameter(Long.class, VALID_UNTIL_BLOCK, new Modifier[0]).addParameter(Integer.class, VERSION, new Modifier[0]).addParameter(Integer.class, CHAIN_ID, new Modifier[0]).addParameter(String.class, VALUE, new Modifier[0]);
        String functionName = functionDefinition.getName();
        methodBuilder.returns((TypeName)SolidityFunctionWrapper.buildRemoteCall(TypeName.get(TransactionReceipt.class)));
        methodBuilder.addStatement("$T function = new $T(\n$S, \n$T.<$T>asList($L), \n$T.<$T<?>>emptyList())", new Object[]{Function.class, Function.class, functionName, Arrays.class, Type.class, inputParams, Collections.class, TypeReference.class});
        if (functionDefinition.isPayable()) {
            methodBuilder.addStatement("return executeRemoteCallTransaction(function, $N, $N, $N, $N, $N, $N, $N)", new Object[]{WEI_VALUE, QUOTA, NONCE, VALID_UNTIL_BLOCK, VERSION, CHAIN_ID, VALUE});
        } else {
            methodBuilder.addStatement("return executeRemoteCallTransaction(function, $N, $N, $N, $N, $N, $N)", new Object[]{QUOTA, NONCE, VALID_UNTIL_BLOCK, VERSION, CHAIN_ID, VALUE});
        }
    }

    TypeSpec buildEventResponseObject(String className, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        TypeName typeName;
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        for (NamedTypeName namedType : indexedParameters) {
            typeName = this.getIndexedEventWrapperType(namedType.typeName);
            builder.addField(typeName, namedType.getName(), new Modifier[]{Modifier.PUBLIC});
        }
        for (NamedTypeName namedType : nonIndexedParameters) {
            typeName = this.getWrapperType(namedType.typeName);
            builder.addField(typeName, namedType.getName(), new Modifier[]{Modifier.PUBLIC});
        }
        return builder.build();
    }

    MethodSpec buildEventObservableFunction(String responseClassName, String functionName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) throws ClassNotFoundException {
        String generatedFunctionName = Strings.lowercaseFirstLetter((String)functionName) + "EventObservable";
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Observable.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        MethodSpec.Builder observableMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(DefaultBlockParameter.class, START_BLOCK, new Modifier[0]).addParameter(DefaultBlockParameter.class, END_BLOCK, new Modifier[0]).returns((TypeName)parameterizedTypeName);
        SolidityFunctionWrapper.buildVariableLengthEventConstructor(observableMethodBuilder, functionName, indexedParameters, nonIndexedParameters);
        TypeSpec converter = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Func1.class), (TypeName[])new TypeName[]{ClassName.get(Log.class), ClassName.get((String)"", (String)responseClassName, (String[])new String[0])})).addMethod(MethodSpec.methodBuilder((String)"call").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Log.class, "log", new Modifier[0]).returns((TypeName)ClassName.get((String)"", (String)responseClassName, (String[])new String[0])).addStatement("$T eventValues = extractEventParameters(event, log)", new Object[]{EventValues.class}).addStatement("$1T typedResponse = new $1T()", new Object[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])}).addCode(this.buildTypedResponse("typedResponse", indexedParameters, nonIndexedParameters)).addStatement("return typedResponse", new Object[0]).build()).build();
        observableMethodBuilder.addStatement("$1T filter = new $1T($2L, $3L, getContractAddress())", new Object[]{AppFilter.class, START_BLOCK, END_BLOCK}).addStatement("filter.addSingleTopic($T.encode(event))", new Object[]{EventEncoder.class}).addStatement("return nervosj.appLogObservable(filter).map($L)", new Object[]{converter});
        return observableMethodBuilder.build();
    }

    MethodSpec buildEventTransactionReceiptFunction(String responseClassName, String functionName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) throws ClassNotFoundException {
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])});
        String generatedFunctionName = "get" + Strings.capitaliseFirstLetter((String)functionName) + "Events";
        MethodSpec.Builder transactionMethodBuilder = MethodSpec.methodBuilder((String)generatedFunctionName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TransactionReceipt.class, "transactionReceipt", new Modifier[0]).returns((TypeName)parameterizedTypeName);
        SolidityFunctionWrapper.buildVariableLengthEventConstructor(transactionMethodBuilder, functionName, indexedParameters, nonIndexedParameters);
        transactionMethodBuilder.addStatement("$T valueList = extractEventParameters(event, transactionReceipt)", new Object[]{ParameterizedTypeName.get(List.class, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{EventValues.class})}).addStatement("$1T responses = new $1T(valueList.size())", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(ArrayList.class), (TypeName[])new TypeName[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])})}).beginControlFlow("for ($T eventValues : valueList)", new Object[]{EventValues.class}).addStatement("$1T typedResponse = new $1T()", new Object[]{ClassName.get((String)"", (String)responseClassName, (String[])new String[0])}).addCode(this.buildTypedResponse("typedResponse", indexedParameters, nonIndexedParameters)).addStatement("responses.add(typedResponse)", new Object[0]).endControlFlow();
        transactionMethodBuilder.addStatement("return responses", new Object[0]);
        return transactionMethodBuilder.build();
    }

    void buildEventFunctions(AbiDefinition functionDefinition, TypeSpec.Builder classBuilder) throws ClassNotFoundException {
        String functionName = functionDefinition.getName();
        List inputs = functionDefinition.getInputs();
        String responseClassName = Strings.capitaliseFirstLetter((String)functionName) + "EventResponse";
        ArrayList<NamedTypeName> indexedParameters = new ArrayList<NamedTypeName>();
        ArrayList<NamedTypeName> nonIndexedParameters = new ArrayList<NamedTypeName>();
        for (AbiDefinition.NamedType namedType : inputs) {
            if (namedType.isIndexed()) {
                indexedParameters.add(new NamedTypeName(namedType.getName(), SolidityFunctionWrapper.buildTypeName(namedType.getType())));
                continue;
            }
            nonIndexedParameters.add(new NamedTypeName(namedType.getName(), SolidityFunctionWrapper.buildTypeName(namedType.getType())));
        }
        classBuilder.addType(this.buildEventResponseObject(responseClassName, indexedParameters, nonIndexedParameters));
        classBuilder.addMethod(this.buildEventTransactionReceiptFunction(responseClassName, functionName, indexedParameters, nonIndexedParameters));
        classBuilder.addMethod(this.buildEventObservableFunction(responseClassName, functionName, indexedParameters, nonIndexedParameters));
    }

    CodeBlock buildTypedResponse(String objectName, List<NamedTypeName> indexedParameters, List<NamedTypeName> nonIndexedParameters) {
        int i;
        String nativeConversion = this.useNativeJavaTypes ? ".getValue()" : "";
        CodeBlock.Builder builder = CodeBlock.builder();
        for (i = 0; i < indexedParameters.size(); ++i) {
            builder.addStatement("$L.$L = ($T) eventValues.getIndexedValues().get($L)" + nativeConversion, new Object[]{objectName, indexedParameters.get(i).getName(), this.getIndexedEventWrapperType(indexedParameters.get(i).getTypeName()), i});
        }
        for (i = 0; i < nonIndexedParameters.size(); ++i) {
            builder.addStatement("$L.$L = ($T) eventValues.getNonIndexedValues().get($L)" + nativeConversion, new Object[]{objectName, nonIndexedParameters.get(i).getName(), this.getWrapperType(nonIndexedParameters.get(i).getTypeName()), i});
        }
        return builder.build();
    }

    static TypeName buildTypeName(String typeDeclaration) {
        String type = SolidityFunctionWrapper.trimStorageDeclaration(typeDeclaration);
        if (type.endsWith("]")) {
            ParameterizedTypeName typeName;
            String[] splitType = type.split("[\\[\\]]");
            Class baseType = AbiTypes.getType((String)splitType[0]);
            if (splitType.length == 1) {
                typeName = ParameterizedTypeName.get(DynamicArray.class, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{baseType});
            } else {
                Class<?> rawType = SolidityFunctionWrapper.getStaticArrayTypeReferenceClass(splitType);
                typeName = ParameterizedTypeName.get(rawType, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{baseType});
            }
            return typeName;
        }
        Class cls = AbiTypes.getType((String)type);
        return ClassName.get((Class)cls);
    }

    private static Class<?> getStaticArrayTypeReferenceClass(String[] splitType) {
        try {
            return Class.forName("org.nervos.appchain.abi.datatypes.generated.StaticArray" + splitType[1]);
        }
        catch (ClassNotFoundException e) {
            return StaticArray.class;
        }
    }

    private static String trimStorageDeclaration(String type) {
        if (type.endsWith(" storage") || type.endsWith(" memory")) {
            return type.split(" ")[0];
        }
        return type;
    }

    private List<TypeName> buildReturnTypes(List<TypeName> outputParameterTypes) {
        ArrayList<TypeName> result = new ArrayList<TypeName>(outputParameterTypes.size());
        for (TypeName typeName : outputParameterTypes) {
            result.add(this.getWrapperType(typeName));
        }
        return result;
    }

    private static void buildVariableLengthReturnFunctionConstructor(MethodSpec.Builder methodBuilder, String functionName, String inputParameters, List<TypeName> outputParameterTypes) throws ClassNotFoundException {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(Function.class);
        objects.add(Function.class);
        objects.add(functionName);
        objects.add(Arrays.class);
        objects.add(Type.class);
        objects.add(inputParameters);
        objects.add(Arrays.class);
        objects.add(TypeReference.class);
        for (TypeName outputParameterType : outputParameterTypes) {
            objects.add(TypeReference.class);
            objects.add(outputParameterType);
        }
        String asListParams = Collection.join(outputParameterTypes, (String)", ", typeName -> "new $T<$T>() {}");
        methodBuilder.addStatement("final $T function = new $T($S, \n$T.<$T>asList($L), \n$T.<$T<?>>asList(" + asListParams + "))", objects.toArray());
    }

    private void buildTupleResultContainer(MethodSpec.Builder methodBuilder, ParameterizedTypeName tupleType, List<TypeName> outputParameterTypes) throws ClassNotFoundException {
        List typeArguments = tupleType.typeArguments;
        CodeBlock.Builder tupleConstructor = CodeBlock.builder();
        tupleConstructor.addStatement("$T results = executeCallMultipleValueReturn(function);", new Object[]{ParameterizedTypeName.get(List.class, (java.lang.reflect.Type[])new java.lang.reflect.Type[]{Type.class})}).add("return new $T(", new Object[]{tupleType}).add("$>$>", new Object[0]);
        String resultStringSimple = "\n($T) results.get($L)";
        if (this.useNativeJavaTypes) {
            resultStringSimple = resultStringSimple + ".getValue()";
        }
        String resultStringNativeList = "\nconvertToNative(($T) results.get($L).getValue())";
        int size = typeArguments.size();
        ClassName classList = ClassName.get(List.class);
        for (int i = 0; i < size; ++i) {
            TypeName param = outputParameterTypes.get(i);
            TypeName convertTo = (TypeName)typeArguments.get(i);
            String resultString = resultStringSimple;
            if (this.useNativeJavaTypes && param instanceof ParameterizedTypeName) {
                ParameterizedTypeName oldContainer = (ParameterizedTypeName)param;
                ParameterizedTypeName newContainer = (ParameterizedTypeName)convertTo;
                if (newContainer.rawType.compareTo(classList) == 0 && newContainer.typeArguments.size() == 1) {
                    convertTo = ParameterizedTypeName.get((ClassName)classList, (TypeName[])new TypeName[]{(TypeName)oldContainer.typeArguments.get(0)});
                    resultString = resultStringNativeList;
                }
            }
            tupleConstructor.add(resultString, new Object[]{convertTo, i});
            tupleConstructor.add(i < size - 1 ? ", " : ");\n", new Object[0]);
        }
        tupleConstructor.add("$<$<", new Object[0]);
        TypeSpec callableType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Callable.class), (TypeName[])new TypeName[]{tupleType})).addMethod(MethodSpec.methodBuilder((String)"call").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addException(Exception.class).returns((TypeName)tupleType).addCode(tupleConstructor.build()).build()).build();
        methodBuilder.addStatement("return new $T(\n$L)", new Object[]{SolidityFunctionWrapper.buildRemoteCall((TypeName)tupleType), callableType});
    }

    private static void buildVariableLengthEventConstructor(MethodSpec.Builder methodBuilder, String eventName, List<NamedTypeName> indexedParameterTypes, List<NamedTypeName> nonIndexedParameterTypes) throws ClassNotFoundException {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(Event.class);
        objects.add(Event.class);
        objects.add(eventName);
        objects.add(Arrays.class);
        objects.add(TypeReference.class);
        for (NamedTypeName indexedParameterType : indexedParameterTypes) {
            objects.add(TypeReference.class);
            objects.add(indexedParameterType.getTypeName());
        }
        objects.add(Arrays.class);
        objects.add(TypeReference.class);
        for (NamedTypeName indexedParameterType : nonIndexedParameterTypes) {
            objects.add(TypeReference.class);
            objects.add(indexedParameterType.getTypeName());
        }
        String indexedAsListParams = Collection.join(indexedParameterTypes, (String)", ", typeName -> "new $T<$T>() {}");
        String nonIndexedAsListParams = Collection.join(nonIndexedParameterTypes, (String)", ", typeName -> "new $T<$T>() {}");
        methodBuilder.addStatement("final $T event = new $T($S, \n$T.<$T<?>>asList(" + indexedAsListParams + "),\n$T.<$T<?>>asList(" + nonIndexedAsListParams + "))", objects.toArray());
    }

    private List<AbiDefinition> loadContractDefinition(String abi) throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        AbiDefinition[] abiDefinition = (AbiDefinition[])objectMapper.readValue(abi, AbiDefinition[].class);
        return Arrays.asList(abiDefinition);
    }

    private static class NamedTypeName {
        private final TypeName typeName;
        private final String name;

        NamedTypeName(String name, TypeName typeName) {
            this.name = name;
            this.typeName = typeName;
        }

        public String getName() {
            return this.name;
        }

        public TypeName getTypeName() {
            return this.typeName;
        }
    }
}

