/*
 * Decompiled with CFR 0.152.
 */
package org.abstractj.kalium.crypto;

import org.abstractj.kalium.NaCl;
import org.abstractj.kalium.crypto.Util;
import org.abstractj.kalium.encoders.Encoder;

public class Aead {
    private byte[] key;
    private boolean aesGcm = false;

    public Aead(byte[] key) {
        this.key = key;
        Util.checkLength(key, 32);
        NaCl.sodium().sodium_init();
    }

    public Aead(String key, Encoder encoder) {
        this(encoder.decode(key));
    }

    public Aead useAesGcm() {
        if (NaCl.sodium().crypto_aead_aes256gcm_is_available() != 1) {
            throw new RuntimeException("AES-GCM requires hardware support");
        }
        this.aesGcm = true;
        return this;
    }

    public byte[] encrypt(byte[] publicNonce, byte[] message, byte[] additionalData) {
        return this.aesGcm ? this.encryptAesGcm(publicNonce, message, additionalData) : this.encryptChaChaPoly(publicNonce, message, additionalData);
    }

    protected byte[] encryptChaChaPoly(byte[] publicNonce, byte[] message, byte[] additionalData) {
        Util.checkLength(publicNonce, 8);
        byte[] ct = Util.zeros(message.length + 16);
        Util.isValid(NaCl.sodium().crypto_aead_chacha20poly1305_encrypt(ct, null, message, message.length, additionalData, additionalData.length, null, publicNonce, this.key), "Encryption failed");
        return ct;
    }

    protected byte[] encryptAesGcm(byte[] publicNonce, byte[] message, byte[] additionalData) {
        Util.checkLength(publicNonce, 12);
        byte[] ct = Util.zeros(message.length + 16);
        Util.isValid(NaCl.sodium().crypto_aead_aes256gcm_encrypt(ct, null, message, message.length, additionalData, additionalData.length, null, publicNonce, this.key), "Encryption failed");
        return ct;
    }

    public byte[] decrypt(byte[] publicNonce, byte[] ciphertext, byte[] additionalData) {
        return this.aesGcm ? this.decryptAesGcm(publicNonce, ciphertext, additionalData) : this.decryptChaChaPoly(publicNonce, ciphertext, additionalData);
    }

    protected byte[] decryptChaChaPoly(byte[] publicNonce, byte[] ciphertext, byte[] additionalData) {
        Util.checkLength(publicNonce, 8);
        byte[] msg = Util.zeros(ciphertext.length - 16);
        Util.isValid(NaCl.sodium().crypto_aead_chacha20poly1305_decrypt(msg, null, null, ciphertext, ciphertext.length, additionalData, additionalData.length, publicNonce, this.key), "Decryption failed. Ciphertext failed verification");
        return msg;
    }

    protected byte[] decryptAesGcm(byte[] publicNonce, byte[] ciphertext, byte[] additionalData) {
        Util.checkLength(publicNonce, 12);
        byte[] msg = Util.zeros(ciphertext.length - 16);
        Util.isValid(NaCl.sodium().crypto_aead_aes256gcm_decrypt(msg, null, null, ciphertext, ciphertext.length, additionalData, additionalData.length, publicNonce, this.key), "Decryption failed. Ciphertext failed verification");
        return msg;
    }
}

