/*
 * Decompiled with CFR 0.152.
 */
package org.abstractj.kalium.crypto;

import org.abstractj.kalium.NaCl;
import org.abstractj.kalium.encoders.Encoder;

public class Hash {
    public byte[] sha256(byte[] message) {
        byte[] buffer = new byte[32];
        NaCl.sodium().crypto_hash_sha256(buffer, message, message.length);
        return buffer;
    }

    public byte[] sha512(byte[] message) {
        byte[] buffer = new byte[64];
        NaCl.sodium().crypto_hash_sha512(buffer, message, message.length);
        return buffer;
    }

    public String sha256(String message, Encoder encoder) {
        byte[] hash = this.sha256(message.getBytes());
        return encoder.encode(hash);
    }

    public String sha512(String message, Encoder encoder) {
        byte[] hash = this.sha512(message.getBytes());
        return encoder.encode(hash);
    }

    public byte[] blake2(byte[] message) throws UnsupportedOperationException {
        byte[] buffer = new byte[32];
        NaCl.sodium().crypto_generichash_blake2b(buffer, 32, message, message.length, null, 0);
        return buffer;
    }

    public String blake2(String message, Encoder encoder) throws UnsupportedOperationException {
        byte[] hash = this.blake2(message.getBytes());
        return encoder.encode(hash);
    }

    public byte[] blake2(byte[] message, byte[] key, byte[] salt, byte[] personal) throws UnsupportedOperationException {
        byte[] buffer = new byte[32];
        NaCl.sodium().crypto_generichash_blake2b_salt_personal(buffer, 32, message, message.length, key, key.length, salt, personal);
        return buffer;
    }
}

