/*
 * Decompiled with CFR 0.152.
 */
package org.abstractj.kalium.crypto;

import org.abstractj.kalium.NaCl;
import org.abstractj.kalium.encoders.Encoder;

public class Password {
    public byte[] deriveKey(int length, byte[] passwd, byte[] salt, int opslimit, long memlimit) {
        byte[] buffer = new byte[length];
        NaCl.sodium().crypto_pwhash_scryptsalsa208sha256(buffer, buffer.length, passwd, passwd.length, salt, opslimit, memlimit);
        return buffer;
    }

    public String hash(byte[] passwd, Encoder encoder, byte[] salt, int opslimit, long memlimit) {
        byte[] buffer = this.deriveKey(64, passwd, salt, opslimit, memlimit);
        return encoder.encode(buffer);
    }

    public String hash(int length, byte[] passwd, Encoder encoder, byte[] salt, int opslimit, long memlimit) {
        byte[] buffer = this.deriveKey(length, passwd, salt, opslimit, memlimit);
        return encoder.encode(buffer);
    }

    public String hash(byte[] passwd, Encoder encoder, int opslimit, long memlimit) {
        byte[] buffer = new byte[102];
        NaCl.sodium().crypto_pwhash_scryptsalsa208sha256_str(buffer, passwd, passwd.length, opslimit, memlimit);
        return encoder.encode(buffer);
    }

    public boolean verify(byte[] hashed_passwd, byte[] passwd) {
        int result = NaCl.sodium().crypto_pwhash_scryptsalsa208sha256_str_verify(hashed_passwd, passwd, passwd.length);
        return result == 0;
    }
}

