/*
 * Decompiled with CFR 0.152.
 */
package org.abstractj.kalium.crypto;

import org.abstractj.kalium.NaCl;
import org.abstractj.kalium.crypto.Util;
import org.abstractj.kalium.encoders.Encoder;

public class SealedBox {
    private byte[] publicKey;
    private byte[] privateKey;

    public SealedBox(byte[] publicKey) {
        this.publicKey = publicKey;
        this.privateKey = null;
    }

    public SealedBox(String publicKey, Encoder encoder) {
        this(encoder.decode(publicKey));
    }

    public SealedBox(byte[] publicKey, byte[] privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public SealedBox(String publicKey, String privateKey, Encoder encoder) {
        this(encoder.decode(publicKey), encoder.decode(privateKey));
    }

    public byte[] encrypt(byte[] message) {
        if (this.publicKey == null) {
            throw new RuntimeException("Encryption failed. Public key not available.");
        }
        byte[] ct = new byte[message.length + 48];
        Util.isValid(NaCl.sodium().crypto_box_seal(ct, message, message.length, this.publicKey), "Encryption failed");
        return ct;
    }

    public byte[] decrypt(byte[] ciphertext) {
        if (this.privateKey == null) {
            throw new RuntimeException("Decryption failed. Private key not available.");
        }
        byte[] message = new byte[ciphertext.length - 48];
        Util.isValid(NaCl.sodium().crypto_box_seal_open(message, ciphertext, ciphertext.length, this.publicKey, this.privateKey), "Decryption failed. Ciphertext failed verification");
        return message;
    }
}

