/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.nervos.appchain.protocol.AppChainjService;
import org.nervos.appchain.protocol.ObjectMapperFactory;
import org.nervos.appchain.protocol.core.Request;
import org.nervos.appchain.protocol.core.Response;
import org.nervos.appchain.utils.Async;

public abstract class Service
implements AppChainjService {
    protected final ObjectMapper objectMapper;

    public Service(boolean includeRawResponses) {
        this.objectMapper = ObjectMapperFactory.getObjectMapper(includeRawResponses);
    }

    protected abstract InputStream performIO(String var1) throws IOException;

    @Override
    public <T extends Response> T send(Request request, Class<T> responseType) throws IOException {
        String payload = this.objectMapper.writeValueAsString((Object)request);
        try (InputStream result = this.performIO(payload);){
            if (result != null) {
                Response response = (Response)this.objectMapper.readValue(result, responseType);
                return (T)response;
            }
            T t = null;
            return t;
        }
    }

    @Override
    public <T extends Response> CompletableFuture<T> sendAsync(Request jsonRpc20Request, Class<T> responseType) {
        return Async.run(() -> this.send(jsonRpc20Request, responseType));
    }
}

