/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.admin;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.nervos.appchain.protocol.AppChainjService;
import org.nervos.appchain.protocol.admin.Admin;
import org.nervos.appchain.protocol.admin.methods.response.NewAccountIdentifier;
import org.nervos.appchain.protocol.admin.methods.response.PersonalListAccounts;
import org.nervos.appchain.protocol.admin.methods.response.PersonalUnlockAccount;
import org.nervos.appchain.protocol.core.JsonRpc2_0AppChainj;
import org.nervos.appchain.protocol.core.Request;
import org.nervos.appchain.protocol.core.methods.request.Transaction;
import org.nervos.appchain.protocol.core.methods.response.AppSendTransaction;

public class JsonRpc2_0Admin
extends JsonRpc2_0AppChainj
implements Admin {
    public JsonRpc2_0Admin(AppChainjService appChainjService) {
        super(appChainjService);
    }

    @Override
    public Request<?, PersonalListAccounts> personalListAccounts() {
        return new Request("personal_listAccounts", Collections.emptyList(), this.appChainjService, PersonalListAccounts.class);
    }

    @Override
    public Request<?, NewAccountIdentifier> personalNewAccount(String password) {
        return new Request<String, NewAccountIdentifier>("personal_newAccount", Arrays.asList(password), this.appChainjService, NewAccountIdentifier.class);
    }

    @Override
    public Request<?, PersonalUnlockAccount> personalUnlockAccount(String accountId, String password, BigInteger duration) {
        ArrayList<Object> attributes = new ArrayList<Object>(3);
        attributes.add(accountId);
        attributes.add(password);
        if (duration != null) {
            attributes.add(duration.longValue());
        } else {
            attributes.add(null);
        }
        return new Request("personal_unlockAccount", attributes, this.appChainjService, PersonalUnlockAccount.class);
    }

    @Override
    public Request<?, PersonalUnlockAccount> personalUnlockAccount(String accountId, String password) {
        return this.personalUnlockAccount(accountId, password, null);
    }

    @Override
    public Request<?, AppSendTransaction> personalSendTransaction(Transaction transaction, String passphrase) {
        return new Request<Object, AppSendTransaction>("personal_sendTransaction", Arrays.asList(transaction, passphrase), this.appChainjService, AppSendTransaction.class);
    }
}

