/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.core.methods.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigInteger;
import java.util.List;
import org.nervos.appchain.utils.Numeric;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ShhPost {
    private String from;
    private String to;
    private List<String> topics;
    private String payload;
    private BigInteger priority;
    private BigInteger ttl;

    public ShhPost(List<String> topics, String payload, BigInteger priority, BigInteger ttl) {
        this.topics = topics;
        this.payload = payload;
        this.priority = priority;
        this.ttl = ttl;
    }

    public ShhPost(String from, String to, List<String> topics, String payload, BigInteger priority, BigInteger ttl) {
        this.from = from;
        this.to = to;
        this.topics = topics;
        this.payload = payload;
        this.priority = priority;
        this.ttl = ttl;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getPriority() {
        return this.convert(this.priority);
    }

    public String getTtl() {
        return this.convert(this.ttl);
    }

    private String convert(BigInteger value) {
        if (value != null) {
            return Numeric.encodeQuantity((BigInteger)value);
        }
        return null;
    }
}

