/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.nervos.appchain.abi.FunctionEncoder;
import org.nervos.appchain.abi.TypeReference;
import org.nervos.appchain.abi.datatypes.Function;
import org.nervos.appchain.abi.datatypes.Type;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.protocol.core.DefaultBlockParameter;
import org.nervos.appchain.protocol.core.methods.request.Call;
import org.nervos.appchain.protocol.core.methods.response.AppCall;

public interface AppChainSystemContract {
    public static final DefaultBlockParameter DEFAULT_BLOCK_PARAMETER = DefaultBlockParameter.valueOf("latest");
    public static final Long DEFAULT_QUOTA = 10000000L;
    public static final String NODE_MANAGER_ADDR = "0xffffffffffffffffffffffffffffffffff020001";
    public static final String NODE_MANAGER_LIST_NODE = "listNode";
    public static final String NODE_MANAGER_GET_STATUS = "getStatus";
    public static final String NODE_MANAGER_LIST_STAKE = "listStake";
    public static final String NODE_MANAGER_STAKE_PERMILLAGE = "stakePermillage";
    public static final String NODE_MANAGER_APPROVE_NODE = "approveNode";
    public static final String NODE_MANAGER_DELETE_NODE = "deleteNode";
    public static final String NODE_MANAGER_SET_STAKE = "setStake";
    public static final String QUOTA_MANAGER_ADDR = "0xffffffffffffffffffffffffffffffffff020003";
    public static final String QUOTA_MANAGER_SET_BQL = "setBQL";
    public static final String QUOTA_MANAGER_SET_DEFAULT_AQL = "setDefaultAQL";
    public static final String QUOTA_MANAGER_SET_AQL = "setAQL";
    public static final String QUOTA_MANAGER_GET_BQL = "getBQL";
    public static final String QUOTA_MANAGER_GET_DEFAULT_AQL = "getDefaultAQL";
    public static final String QUOTA_MANAGER_GET_AQL = "getAQL";
    public static final String QUOTA_MANAGER_GET_ACCOUNTS = "getAccounts";
    public static final String QUOTA_MANAGER_GET_QUOTAS = "getQuotas";
    public static final String PRICE_MANAGER_ADDR = "0xffffffffffffffffffffffffffffffffff020010";
    public static final String PRICE_MANAGER_GET_QUOTA_PRICE = "getQuotaPrice";
    public static final String PERMISSION_MANAGER_ADDR = "0xffffffffffffffffffffffffffffffffff020010";
    public static final String PERMISSION_MANAGER_NEW_PERMISSION = "newPermission";
    public static final String PERMISSION_MANAGER_DELETE_PERMISSION = "deletePermission";
    public static final String PERMISSION_MANAGER_UPDATE_PERMISSION_NAME = "updatePermissionName";
    public static final String PERMISSION_MANAGER_ADD_RESOURCES = "addResources";
    public static final String PERMISSION_MANAGER_DELETE_RESOURCES = "deleteResources";
    public static final String PERMISSION_MANAGER_SET_AUTHORIZATION = "setAuthorization";
    public static final String PERMISSION_MANAGER_SET_AUTHORIZATIONS = "setAuthorizations";
    public static final String PERMISSION_MANAGER_CANCEL_AUTHORIZATION = "cancelAuthorization";
    public static final String PERMISSION_MANAGER_CANCEL_AUTHORIZATIONS = "cancelAuthorizations";
    public static final String PERMISSION_MANAGER_CLEAR_AUTHORIZATION = "clearAuthorization";
    public static final String PERMISSION_MANAGER_QUERY_ALL_ACCOUNTS = "queryAllAccounts";
    public static final String PERMISSION_MANAGER_QUERY_PERMISSION = "queryPermissions";
    public static final String PERMISSION_MANAGER_QUERY_ACCOUNTS = "queryAccounts";
    public static final String PERMISSION_MANAGER_CHECK_PERMISSON = "checkPermission";
    public static final String PERMISSION_MANAGER_CHECK_RESOURCE = "checkResource";
    public static final String PERMISSION_MANAGER_IN_PERMISSION = "inPermission";
    public static final String PERMISSION_MANAGER_QUERY_INFO = "queryInfo";
    public static final String PERMISSION_MANAGER_QUERY_NAME = "queryName";
    public static final String PERMISSION_MANAGER_QUERY_RESOURCE = "queryResource";
    public static final String USER_MANAGER_ADDR = "0xffffffffffffffffffffffffffffffffff020010";
    public static final String USER_MANAGER_NEW_GROUP = "newGroup";
    public static final String USER_MANAGER_DELETE_GROUP = "deleteGroup";
    public static final String USER_MANAGER_UPDATE_GROUP_NAME = "updateGroupName";
    public static final String USER_MANAGER_ADD_ACCOUNTS = "addAccounts";
    public static final String USER_MANAGER_DELETE_ACCOUNTS = "deleteAccounts";
    public static final String USER_MANAGER_QUERY_INFO = "queryInfo";
    public static final String USER_MANAGER_QUERY_NAME = "queryName";
    public static final String USER_MANAGER_QUERY_ACCOUNTS = "queryAccounts";
    public static final String USER_MANAGER_QUERY_CHILD = "queryChild";
    public static final String USER_MANAGER_QUERY_CHILD_LENGHT = "queryChildLength";
    public static final String USER_MANAGER_QUERY_PARENT = "queryParent";
    public static final String USER_MANAGER_IN_GROUP = "inGroup";
    public static final String USER_MANAGER_CHECK_SCOPE = "checkScope";
    public static final String USER_MANAGER_QUERY_GROUPS = "queryGroups";

    public static List<TypeReference<Type>> convert(List<TypeReference<?>> input) {
        ArrayList<TypeReference<Type>> result = new ArrayList<TypeReference<Type>>(input.size());
        result.addAll(input.stream().map(typeReference -> typeReference).collect(Collectors.toList()));
        return result;
    }

    public static String encodeCall(String methodName) {
        Function callFunc = new Function(methodName, Collections.emptyList(), Collections.emptyList());
        return FunctionEncoder.encode((Function)callFunc);
    }

    public static String encodeFunction(String methodName, List<Type> inputParameters) {
        Function func = new Function(methodName, inputParameters, Collections.emptyList());
        return FunctionEncoder.encode((Function)func);
    }

    public static AppCall sendCall(String from, String addr, String callData, AppChainj service) throws IOException {
        Call call = new Call(from, addr, callData);
        return service.appCall(call, DEFAULT_BLOCK_PARAMETER).send();
    }

    public int getQuotaPrice(String var1) throws IOException;
}

