/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.crypto;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nervos.appchain.crypto.ECKeyPair;
import org.nervos.appchain.crypto.Hash;
import org.nervos.appchain.crypto.SecureRandomUtils;
import org.nervos.appchain.utils.Numeric;
import org.nervos.appchain.utils.Strings;

public class Keys {
    static final int PRIVATE_KEY_SIZE = 32;
    static final int PUBLIC_KEY_SIZE = 64;
    public static final int ADDRESS_SIZE = 160;
    public static final int ADDRESS_LENGTH_IN_HEX = 40;
    static final int PUBLIC_KEY_LENGTH_IN_HEX = 128;
    public static final int PRIVATE_KEY_LENGTH_IN_HEX = 64;
    static final String ADDR_REGEX = "^(0x|0X)?[a-fA-F0-9]{40}$";
    static final String PRIVATE_KEY_REGEX = "^(0x|0X)?[a-fA-F0-9]{64}$";

    private Keys() {
    }

    static KeyPair createSecp256k1KeyPair() throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec("secp256k1");
        keyPairGenerator.initialize(ecGenParameterSpec, SecureRandomUtils.secureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    public static ECKeyPair createEcKeyPair() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair keyPair = Keys.createSecp256k1KeyPair();
        return ECKeyPair.create(keyPair);
    }

    public static String getAddress(ECKeyPair ecKeyPair) {
        return Keys.getAddress(ecKeyPair.getPublicKey());
    }

    public static String getAddress(BigInteger publicKey) {
        return Keys.getAddress(Numeric.toHexStringWithPrefixZeroPadded((BigInteger)publicKey, (int)128));
    }

    public static String getAddress(String publicKey) {
        String publicKeyNoPrefix = Numeric.cleanHexPrefix((String)publicKey);
        if (publicKeyNoPrefix.length() < 128) {
            publicKeyNoPrefix = Strings.zeros((int)(128 - publicKeyNoPrefix.length())) + publicKeyNoPrefix;
        }
        String hash = Hash.sha3((String)publicKeyNoPrefix);
        return hash.substring(hash.length() - 40);
    }

    public static byte[] getAddress(byte[] publicKey) {
        byte[] hash = Hash.sha3((byte[])publicKey);
        return Arrays.copyOfRange(hash, hash.length - 20, hash.length);
    }

    public static byte[] serialize(ECKeyPair ecKeyPair) {
        byte[] privateKey = Numeric.toBytesPadded((BigInteger)ecKeyPair.getPrivateKey(), (int)32);
        byte[] publicKey = Numeric.toBytesPadded((BigInteger)ecKeyPair.getPublicKey(), (int)64);
        byte[] result = Arrays.copyOf(privateKey, 96);
        System.arraycopy(publicKey, 0, result, 32, 64);
        return result;
    }

    public static ECKeyPair deserialize(byte[] input) {
        if (input.length != 96) {
            throw new RuntimeException("Invalid input key size");
        }
        BigInteger privateKey = Numeric.toBigInt((byte[])input, (int)0, (int)32);
        BigInteger publicKey = Numeric.toBigInt((byte[])input, (int)32, (int)64);
        return new ECKeyPair(privateKey, publicKey);
    }

    public static boolean verifyAddress(String address) {
        return address.matches(ADDR_REGEX);
    }

    public static boolean verifyPrivateKey(String privateKey) {
        return privateKey.matches(PRIVATE_KEY_REGEX);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

