/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import org.nervos.appchain.abi.datatypes.Address;
import org.nervos.appchain.abi.datatypes.Bool;
import org.nervos.appchain.abi.datatypes.Bytes;
import org.nervos.appchain.abi.datatypes.DynamicBytes;
import org.nervos.appchain.abi.datatypes.Fixed;
import org.nervos.appchain.abi.datatypes.Int;
import org.nervos.appchain.abi.datatypes.Ufixed;
import org.nervos.appchain.abi.datatypes.Uint;
import org.nervos.appchain.abi.datatypes.Utf8String;
import org.nervos.appchain.codegen.Generator;

public class AbiTypesMapperGenerator
extends Generator {
    private static final String TYPE = "type";

    public static void main(String[] args) throws Exception {
        AbiTypesMapperGenerator abiTypesMapperGenerator = new AbiTypesMapperGenerator();
        if (args.length == 1) {
            abiTypesMapperGenerator.generate(args[0]);
        } else {
            abiTypesMapperGenerator.generate(System.getProperty("user.dir") + "/core/src/main/java/");
        }
    }

    private void generate(String destinationDir) throws IOException {
        String typesPackageName = "org.nervos.appchain.abi.datatypes";
        String autoGeneratedTypesPackageName = typesPackageName + ".generated";
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getType").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(String.class, TYPE, new Modifier[0]).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})).beginControlFlow("switch (type)", new Object[0]);
        builder = this.addTypes(builder, typesPackageName);
        builder = this.addGeneratedTypes(builder, autoGeneratedTypesPackageName);
        builder = builder.addStatement("default:\nthrow new $T($S)", new Object[]{UnsupportedOperationException.class, "Unsupported type encountered"});
        builder.endControlFlow();
        MethodSpec methodSpec = builder.build();
        MethodSpec constructorSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        TypeSpec typeSpec = TypeSpec.classBuilder((String)"AbiTypes").addJavadoc(AbiTypesMapperGenerator.buildWarning(AbiTypesMapperGenerator.class), new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(constructorSpec).addMethod(methodSpec).build();
        this.write(autoGeneratedTypesPackageName, typeSpec, destinationDir);
    }

    private MethodSpec.Builder addTypes(MethodSpec.Builder builder, String packageName) {
        builder = this.addStatement(builder, packageName, "address", Address.class.getSimpleName());
        builder = this.addStatement(builder, packageName, "bool", Bool.class.getSimpleName());
        builder = this.addStatement(builder, packageName, "string", Utf8String.class.getSimpleName());
        builder = this.addStatement(builder, packageName, "bytes", DynamicBytes.class.getSimpleName());
        return builder;
    }

    private MethodSpec.Builder addGeneratedTypes(MethodSpec.Builder builder, String packageName) {
        builder = this.generateIntTypes(builder, packageName);
        builder = this.generateFixedBytesTypes(builder, packageName);
        return builder;
    }

    private MethodSpec.Builder generateIntTypes(MethodSpec.Builder builder, String packageName) {
        for (int bitSize = 8; bitSize <= 256; bitSize += 8) {
            builder = this.addStatement(builder, packageName, "uint" + bitSize, Uint.class.getSimpleName() + bitSize);
            builder = this.addStatement(builder, packageName, "int" + bitSize, Int.class.getSimpleName() + bitSize);
        }
        return builder;
    }

    private MethodSpec.Builder generateFixedTypes(MethodSpec.Builder builder, String packageName) {
        int mBitSize = 8;
        for (int nBitSize = 248; mBitSize < 256 && nBitSize > 0; mBitSize += 8, nBitSize -= 8) {
            String suffix = mBitSize + "x" + nBitSize;
            builder = this.addStatement(builder, packageName, "ufixed" + suffix, Ufixed.class.getSimpleName() + suffix);
            builder = this.addStatement(builder, packageName, "fixed" + suffix, Fixed.class.getSimpleName() + suffix);
        }
        return builder;
    }

    private MethodSpec.Builder generateFixedBytesTypes(MethodSpec.Builder builder, String packageName) {
        for (int byteSize = 1; byteSize <= 32; ++byteSize) {
            builder = this.addStatement(builder, packageName, "bytes" + byteSize, Bytes.class.getSimpleName() + byteSize);
        }
        return builder;
    }

    private MethodSpec.Builder addStatement(MethodSpec.Builder builder, String packageName, String typeName, String className) {
        return builder.addStatement("case \"$L\":\nreturn $T.class", new Object[]{typeName, ClassName.get((String)packageName, (String)className, (String[])new String[0])});
    }
}

