/*
 * Decompiled with CFR 0.152.
 */
package org.abstractj.kalium.crypto;

import org.abstractj.kalium.NaCl;
import org.abstractj.kalium.crypto.Util;
import org.abstractj.kalium.encoders.Encoder;
import org.abstractj.kalium.keys.PrivateKey;
import org.abstractj.kalium.keys.PublicKey;

public class Box {
    private final byte[] sharedKey;

    public Box(byte[] publicKey, byte[] privateKey) {
        Util.checkLength(publicKey, 32);
        Util.checkLength(privateKey, 32);
        this.sharedKey = new byte[32];
        Util.isValid(NaCl.sodium().crypto_box_curve25519xsalsa20poly1305_beforenm(this.sharedKey, publicKey, privateKey), "Key agreement failed");
    }

    public Box(PublicKey publicKey, PrivateKey privateKey) {
        this(publicKey.toBytes(), privateKey.toBytes());
    }

    public Box(String publicKey, String privateKey, Encoder encoder) {
        this(encoder.decode(publicKey), encoder.decode(privateKey));
    }

    public byte[] encrypt(byte[] nonce, byte[] message) {
        Util.checkLength(nonce, 24);
        byte[] msg = Util.prependZeros(32, message);
        byte[] ct = new byte[msg.length];
        Util.isValid(NaCl.sodium().crypto_box_curve25519xsalsa20poly1305_afternm(ct, msg, msg.length, nonce, this.sharedKey), "Encryption failed");
        return Util.removeZeros(16, ct);
    }

    public byte[] encrypt(String nonce, String message, Encoder encoder) {
        return this.encrypt(encoder.decode(nonce), encoder.decode(message));
    }

    public byte[] decrypt(byte[] nonce, byte[] ciphertext) {
        Util.checkLength(nonce, 24);
        byte[] ct = Util.prependZeros(16, ciphertext);
        byte[] message = new byte[ct.length];
        Util.isValid(NaCl.sodium().crypto_box_curve25519xsalsa20poly1305_open_afternm(message, ct, message.length, nonce, this.sharedKey), "Decryption failed. Ciphertext failed verification.");
        return Util.removeZeros(32, message);
    }

    public byte[] decrypt(String nonce, String ciphertext, Encoder encoder) {
        return this.decrypt(encoder.decode(nonce), encoder.decode(ciphertext));
    }
}

