/*
 * Decompiled with CFR 0.152.
 */
package org.abstractj.kalium.crypto;

import org.abstractj.kalium.NaCl;
import org.abstractj.kalium.crypto.Util;
import org.abstractj.kalium.encoders.Encoder;

public class SecretBox {
    private byte[] key;

    public SecretBox(byte[] key) {
        this.key = key;
        Util.checkLength(key, 32);
    }

    public SecretBox(String key, Encoder encoder) {
        this(encoder.decode(key));
    }

    public byte[] encrypt(byte[] nonce, byte[] message) {
        Util.checkLength(nonce, 24);
        byte[] msg = Util.prependZeros(32, message);
        byte[] ct = Util.zeros(msg.length);
        Util.isValid(NaCl.sodium().crypto_secretbox_xsalsa20poly1305(ct, msg, msg.length, nonce, this.key), "Encryption failed");
        return Util.removeZeros(16, ct);
    }

    public byte[] decrypt(byte[] nonce, byte[] ciphertext) {
        Util.checkLength(nonce, 24);
        byte[] ct = Util.prependZeros(16, ciphertext);
        byte[] message = Util.zeros(ct.length);
        Util.isValid(NaCl.sodium().crypto_secretbox_xsalsa20poly1305_open(message, ct, ct.length, nonce, this.key), "Decryption failed. Ciphertext failed verification");
        return Util.removeZeros(32, message);
    }
}

