/*
 * Decompiled with CFR 0.152.
 */
package org.abstractj.kalium.crypto;

import java.util.Arrays;

public class Util {
    private static final int DEFAULT_SIZE = 32;

    public static byte[] prependZeros(int n, byte[] message) {
        byte[] result = new byte[n + message.length];
        System.arraycopy(message, 0, result, n, message.length);
        return result;
    }

    public static byte[] removeZeros(int n, byte[] message) {
        return Arrays.copyOfRange(message, n, message.length);
    }

    public static void checkLength(byte[] data, int size) {
        if (data == null || data.length != size) {
            throw new RuntimeException("Invalid size");
        }
    }

    public static byte[] zeros(int n) {
        return new byte[n];
    }

    public static boolean isValid(int status, String message) {
        if (status != 0) {
            throw new RuntimeException(message);
        }
        return true;
    }

    public static byte[] slice(byte[] buffer, int start, int end) {
        return Arrays.copyOfRange(buffer, start, end);
    }

    public static byte[] merge(byte[] signature, byte[] message) {
        byte[] result = new byte[signature.length + message.length];
        System.arraycopy(signature, 0, result, 0, signature.length);
        System.arraycopy(message, 0, result, signature.length, message.length);
        return result;
    }
}

