/*
 * Decompiled with CFR 0.152.
 */
package org.abstractj.kalium.keys;

import org.abstractj.kalium.NaCl;
import org.abstractj.kalium.crypto.Point;
import org.abstractj.kalium.crypto.Util;
import org.abstractj.kalium.encoders.Encoder;
import org.abstractj.kalium.keys.PrivateKey;
import org.abstractj.kalium.keys.PublicKey;

public class KeyPair {
    private byte[] publicKey;
    private final byte[] secretKey;

    public KeyPair() {
        this.secretKey = Util.zeros(32);
        this.publicKey = Util.zeros(32);
        NaCl.sodium().crypto_box_curve25519xsalsa20poly1305_keypair(this.publicKey, this.secretKey);
    }

    public KeyPair(byte[] secretKey) {
        this.secretKey = secretKey;
        Util.checkLength(this.secretKey, 32);
        Point point = new Point();
        this.publicKey = point.mult(secretKey).toBytes();
    }

    public KeyPair(String secretKey, Encoder encoder) {
        this(encoder.decode(secretKey));
    }

    public PublicKey getPublicKey() {
        return new PublicKey(this.publicKey);
    }

    public PrivateKey getPrivateKey() {
        return new PrivateKey(this.secretKey);
    }
}

