/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.account;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.nervos.appchain.abi.EventEncoder;
import org.nervos.appchain.abi.EventValues;
import org.nervos.appchain.abi.FunctionEncoder;
import org.nervos.appchain.abi.FunctionReturnDecoder;
import org.nervos.appchain.abi.TypeReference;
import org.nervos.appchain.abi.datatypes.Function;
import org.nervos.appchain.abi.datatypes.Type;
import org.nervos.appchain.abi.datatypes.UnorderedEvent;
import org.nervos.appchain.crypto.Credentials;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.protocol.account.CompiledContract;
import org.nervos.appchain.protocol.core.DefaultBlockParameter;
import org.nervos.appchain.protocol.core.DefaultBlockParameterName;
import org.nervos.appchain.protocol.core.methods.request.AppFilter;
import org.nervos.appchain.protocol.core.methods.request.Call;
import org.nervos.appchain.protocol.core.methods.response.AbiDefinition;
import org.nervos.appchain.protocol.core.methods.response.AppCall;
import org.nervos.appchain.protocol.core.methods.response.AppSendTransaction;
import org.nervos.appchain.protocol.core.methods.response.Log;
import org.nervos.appchain.tx.CitaTransactionManager;
import org.nervos.appchain.utils.TypedAbi;
import rx.Observable;

public class Account {
    private static final String ABI_ADDRESS = "ffffffffffffffffffffffffffffffffff010001";
    private CitaTransactionManager transactionManager;
    private AppChainj service;
    private String abi;

    public Account(String privateKey, AppChainj service) {
        Credentials credentials = Credentials.create((String)privateKey);
        this.transactionManager = new CitaTransactionManager(service, credentials);
        this.service = service;
    }

    public CitaTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public AppSendTransaction deploy(File contractFile, String nonce, long quota, int version, int chainId, String value) throws IOException, InterruptedException, CompiledContract.ContractCompileError {
        CompiledContract contract = new CompiledContract(contractFile);
        String contractBin = contract.getBin();
        return this.transactionManager.sendTransaction("", contractBin, quota, nonce, this.getValidUntilBlock(), version, chainId, value);
    }

    public CompletableFuture<AppSendTransaction> deployAsync(File contractFile, String nonce, long quota, int version, int chainId, String value) throws IOException, InterruptedException, CompiledContract.ContractCompileError {
        CompiledContract contract = new CompiledContract(contractFile);
        String contractBin = contract.getBin();
        return this.transactionManager.sendTransactionAsync("", contractBin, quota, nonce, this.getValidUntilBlock(), version, chainId, value);
    }

    public Object callContract(String contractAddress, String funcName, String nonce, long quota, int version, int chainId, String value, Object ... args) throws Exception {
        if (this.abi == null) {
            this.abi = this.getAbi(contractAddress);
        }
        CompiledContract contract = new CompiledContract(this.abi);
        AbiDefinition functionAbi = contract.getFunctionAbi(funcName, args.length);
        return this.callContract(contractAddress, functionAbi, nonce, quota, version, chainId, value, args);
    }

    public Object callContract(String contractAddress, AbiDefinition functionAbi, String nonce, long quota, int version, int chainId, String value, Object ... args) throws Exception {
        ArrayList<Type> params = new ArrayList<Type>();
        List<AbiDefinition.NamedType> inputs = functionAbi.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            Object arg = args[i];
            String typeName = inputs.get(i).getType();
            params.add(TypedAbi.getType(typeName, arg));
        }
        if (functionAbi.isConstant()) {
            ArrayList<TypedAbi.ArgRetType> retsType = new ArrayList<TypedAbi.ArgRetType>();
            ArrayList<TypeReference> retsTypeRef = new ArrayList<TypeReference>();
            List<AbiDefinition.NamedType> outputs = functionAbi.getOutputs();
            for (AbiDefinition.NamedType namedType : outputs) {
                TypedAbi.ArgRetType retType = TypedAbi.getArgRetType(namedType.getType());
                retsType.add(retType);
                retsTypeRef.add(retType.getTypeReference());
            }
            Function func = new Function(functionAbi.getName(), params, retsTypeRef);
            return this.ethCall(contractAddress, func, retsType);
        }
        Function func = new Function(functionAbi.getName(), params, Collections.emptyList());
        return this.sendTransaction(contractAddress, func, nonce, quota, version, chainId, value);
    }

    public Object ethCall(String contractAddress, Function func, List<TypedAbi.ArgRetType> retsType) throws IOException {
        String data = FunctionEncoder.encode((Function)func);
        AppCall call = this.service.appCall(new Call(this.transactionManager.getFromAddress(), contractAddress, data), DefaultBlockParameterName.LATEST).send();
        String value = call.getValue();
        List abiValues = FunctionReturnDecoder.decode((String)value, (List)func.getOutputParameters());
        if (retsType.size() == 1) {
            return retsType.get(0).abiToJava((Type)abiValues.get(0));
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < retsType.size(); ++i) {
            results.add(retsType.get(i).abiToJava((Type)abiValues.get(i)));
        }
        return results;
    }

    public Object sendTransaction(String contractAddress, Function func, String nonce, long quota, int version, int chainId, String value) throws IOException {
        String data = FunctionEncoder.encode((Function)func);
        return this.transactionManager.sendTransaction(contractAddress, data, quota, nonce, this.getValidUntilBlock(), version, chainId, value);
    }

    public Object uploadAbi(String contractAddress, String abi, String nonce, long quota, int version, int chainId, String value) throws Exception {
        String data = this.hex_remove_0x(contractAddress) + this.hex_remove_0x(this.bytesToHexStr(abi.getBytes()));
        return this.transactionManager.sendTransaction(ABI_ADDRESS, data, quota, nonce, this.getValidUntilBlock(), version, chainId, value);
    }

    public String getAbi(String contractAddress) throws IOException {
        String abi = this.service.appGetAbi(contractAddress, DefaultBlockParameter.valueOf("latest")).send().getAbi();
        return new String(this.hexStrToBytes(this.hex_remove_0x(abi)));
    }

    public Observable<Object> eventObservable(String contractName, String eventName) throws Exception {
        CompiledContract contract = this.loadContract(contractName);
        String contractAddress = this.getContractAddress(contractName);
        AbiDefinition eventAbi = contract.getEventAbi(eventName);
        return this.eventObservable(contractAddress, eventAbi, DefaultBlockParameterName.EARLIEST, DefaultBlockParameterName.LATEST);
    }

    public Observable<Object> eventObservable(String contractAddress, AbiDefinition eventAbi, DefaultBlockParameter start, DefaultBlockParameter end) throws Exception {
        ArrayList<TypedAbi.ArgRetType> results = new ArrayList<TypedAbi.ArgRetType>();
        List<AbiDefinition.NamedType> namedTypes = eventAbi.getInputs();
        UnorderedEvent event = new UnorderedEvent(eventAbi.getName());
        for (AbiDefinition.NamedType namedType : namedTypes) {
            TypedAbi.ArgRetType argRetType = TypedAbi.getArgRetType(namedType.getType());
            results.add(argRetType);
            event.add(namedType.isIndexed(), argRetType.getTypeReference());
        }
        AppFilter filter = new AppFilter(start, end, contractAddress);
        filter.addSingleTopic(EventEncoder.encode((UnorderedEvent)event));
        return this.service.appLogObservable(filter).map(log -> {
            EventValues eventValues = Account.staticExtractEventParameters(event, log);
            List indexedValues = eventValues.getIndexedValues();
            List nonIndexedValues = eventValues.getNonIndexedValues();
            int indexedSize = indexedValues.size();
            int nonIndexedSize = nonIndexedValues.size();
            int size = indexedSize + nonIndexedSize;
            ArrayList<Object> values = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                values.add(null);
            }
            List indexedSeq = event.getIndexedParametersSeq();
            for (int i = 0; i < indexedSize; ++i) {
                int indexSeqNum = (Integer)indexedSeq.get(i);
                values.set(indexSeqNum, ((TypedAbi.ArgRetType)results.get(indexSeqNum)).abiToJava((Type)indexedValues.get(i)));
            }
            List nonIndexedSeq = event.getNonIndexedParametersSeq();
            for (int i = 0; i < nonIndexedSize; ++i) {
                int indexSeqNum = (Integer)nonIndexedSeq.get(i);
                values.set(indexSeqNum, ((TypedAbi.ArgRetType)results.get(indexSeqNum)).abiToJava((Type)nonIndexedValues.get(i)));
            }
            return values;
        });
    }

    private static EventValues staticExtractEventParameters(UnorderedEvent event, Log log) {
        List<String> topics = log.getTopics();
        String encodedEventSignature = EventEncoder.encode((UnorderedEvent)event);
        if (!topics.get(0).equals(encodedEventSignature)) {
            return null;
        }
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        List nonIndexedValues = FunctionReturnDecoder.decode((String)log.getData(), (List)event.getNonIndexedParameters());
        List indexedParameters = event.getIndexedParameters();
        for (int i = 0; i < indexedParameters.size(); ++i) {
            Type value = FunctionReturnDecoder.decodeIndexedValue((String)topics.get(i + 1), (TypeReference)((TypeReference)indexedParameters.get(i)));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }

    private CompiledContract loadContract(String contractName) throws IOException {
        return new CompiledContract("");
    }

    private String getContractAddress(String contractName) {
        return "";
    }

    private long blockHeight() throws IOException {
        return this.service.appBlockNumber().send().getBlockNumber().longValue();
    }

    private long getValidUntilBlock() throws IOException {
        return this.blockHeight() + 80L;
    }

    private String hex_remove_0x(String hex) {
        if (hex.contains("0x")) {
            return hex.substring(2);
        }
        return hex;
    }

    private String bytesToHexStr(byte[] byteArr) {
        if (null == byteArr || byteArr.length < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte t : byteArr) {
            if ((t & 0xF0) == 0) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(t & 0xFF));
        }
        return sb.toString();
    }

    private byte[] hexStrToBytes(String hexStr) {
        if (null == hexStr || hexStr.length() < 1) {
            return null;
        }
        int byteLen = hexStr.length() / 2;
        byte[] result = new byte[byteLen];
        char[] hexChar = hexStr.toCharArray();
        for (int i = 0; i < byteLen; ++i) {
            result[i] = (byte)(Character.digit(hexChar[i * 2], 16) << 4 | Character.digit(hexChar[i * 2 + 1], 16));
        }
        return result;
    }
}

