/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.account;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.nervos.appchain.protocol.ObjectMapperFactory;
import org.nervos.appchain.protocol.core.methods.response.AbiDefinition;
import org.nervos.appchain.utils.CallCmd;

public class CompiledContract {
    private String bin;
    private String abi;
    private List<AbiDefinition> typedABI;

    public CompiledContract(File contractFile) throws IOException, InterruptedException, ContractCompileError {
        String fileName = contractFile.getName();
        if (fileName.indexOf(".") > 0) {
            fileName = fileName.substring(0, fileName.indexOf("."));
        }
        this.generateAbiAndBin(contractFile);
        String binPath = "/tmp/" + fileName + ".bin";
        String abiPath = "/tmp/" + fileName + ".abi";
        this.bin = new String(Files.readAllBytes(Paths.get(binPath, new String[0])));
        this.abi = new String(Files.readAllBytes(Paths.get(abiPath, new String[0])));
        this.typedABI = this.generateTypedABI();
    }

    public CompiledContract(String abi) throws IOException {
        this.abi = abi;
        this.typedABI = this.generateTypedABI();
    }

    private void generateAbiAndBin(File contractFile) throws IOException, InterruptedException, ContractCompileError {
        String callSolcCmd = String.format("solc %s --abi --bin --optimize --overwrite -o /tmp/", contractFile.getAbsolutePath());
        CallCmd.ExecutedResult result = CallCmd.callCmd(callSolcCmd);
        if (result.exitCode != 0) {
            throw new ContractCompileError(result.output);
        }
    }

    private List<AbiDefinition> generateTypedABI() throws IOException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        AbiDefinition[] typedABI = (AbiDefinition[])objectMapper.readValue(this.abi, AbiDefinition[].class);
        return Arrays.asList(typedABI);
    }

    public List<AbiDefinition> getTypedABI() {
        return this.typedABI;
    }

    public String getBin() {
        return this.bin;
    }

    public String getAbi() {
        return this.abi;
    }

    public AbiDefinition getFunctionAbi(String funcName, int numOfArgs) throws ContractFuncNotFound {
        Object[] abiDefinitions = this.typedABI.stream().filter(abiDefinition -> abiDefinition.getType().equals("function") && abiDefinition.getName().equals(funcName) && abiDefinition.getInputs().size() == numOfArgs).toArray();
        if (abiDefinitions.length == 0) {
            throw new ContractFuncNotFound(funcName, numOfArgs);
        }
        return (AbiDefinition)abiDefinitions[0];
    }

    public AbiDefinition getEventAbi(String eventName) {
        Object[] abiDefinitions = this.typedABI.stream().filter(abiDefinition -> abiDefinition.getType().equals("event") && abiDefinition.getName().equals(eventName)).toArray();
        return (AbiDefinition)abiDefinitions[0];
    }

    public static class ContractFuncNotFound
    extends Exception {
        private String funcName;
        private int numOfArgs;

        public ContractFuncNotFound(String func, int num) {
            this.funcName = func;
            this.numOfArgs = num;
        }

        @Override
        public String toString() {
            return "contract method " + this.funcName + " with " + this.numOfArgs + " args  not found";
        }
    }

    public static class ContractCompileError
    extends Exception {
        private String errorMessage;

        public ContractCompileError(String error) {
            this.errorMessage = error;
        }

        @Override
        public String toString() {
            return "complie contract failed because of " + this.errorMessage;
        }
    }
}

