/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.core;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.protocol.AppChainjService;
import org.nervos.appchain.protocol.core.DefaultBlockParameter;
import org.nervos.appchain.protocol.core.Request;
import org.nervos.appchain.protocol.core.methods.request.AppFilter;
import org.nervos.appchain.protocol.core.methods.request.Call;
import org.nervos.appchain.protocol.core.methods.response.AppAccounts;
import org.nervos.appchain.protocol.core.methods.response.AppBlock;
import org.nervos.appchain.protocol.core.methods.response.AppBlockNumber;
import org.nervos.appchain.protocol.core.methods.response.AppCall;
import org.nervos.appchain.protocol.core.methods.response.AppGetAbi;
import org.nervos.appchain.protocol.core.methods.response.AppGetBalance;
import org.nervos.appchain.protocol.core.methods.response.AppGetCode;
import org.nervos.appchain.protocol.core.methods.response.AppGetTransactionCount;
import org.nervos.appchain.protocol.core.methods.response.AppGetTransactionReceipt;
import org.nervos.appchain.protocol.core.methods.response.AppLog;
import org.nervos.appchain.protocol.core.methods.response.AppMetaData;
import org.nervos.appchain.protocol.core.methods.response.AppSendTransaction;
import org.nervos.appchain.protocol.core.methods.response.AppSign;
import org.nervos.appchain.protocol.core.methods.response.AppTransaction;
import org.nervos.appchain.protocol.core.methods.response.AppUninstallFilter;
import org.nervos.appchain.protocol.core.methods.response.Log;
import org.nervos.appchain.protocol.core.methods.response.NetPeerCount;
import org.nervos.appchain.protocol.core.methods.response.Transaction;
import org.nervos.appchain.protocol.rx.JsonRpc2_0Rx;
import org.nervos.appchain.utils.Async;
import org.nervos.appchain.utils.Numeric;
import rx.Observable;

public class JsonRpc2_0AppChainj
implements AppChainj {
    public static final int DEFAULT_BLOCK_TIME = 15000;
    protected final AppChainjService appChainjService;
    private final JsonRpc2_0Rx appChainjRx;
    private final long blockTime;

    public JsonRpc2_0AppChainj(AppChainjService appChainjService) {
        this(appChainjService, 15000L, Async.defaultExecutorService());
    }

    public JsonRpc2_0AppChainj(AppChainjService appChainjService, long pollingInterval) {
        this(appChainjService, pollingInterval, Async.defaultExecutorService());
    }

    public JsonRpc2_0AppChainj(AppChainjService appChainjService, long pollingInterval, ScheduledExecutorService scheduledExecutorService) {
        this.appChainjService = appChainjService;
        this.appChainjRx = new JsonRpc2_0Rx(this, scheduledExecutorService);
        this.blockTime = pollingInterval;
    }

    @Override
    public Request<?, NetPeerCount> netPeerCount() {
        return new Request("peerCount", Collections.emptyList(), this.appChainjService, NetPeerCount.class);
    }

    @Override
    public Request<?, AppAccounts> appAccounts() {
        return new Request("accounts", Collections.emptyList(), this.appChainjService, AppAccounts.class);
    }

    @Override
    public Request<?, AppSign> appSign(String address, String sha3HashOfDataToSign) {
        return new Request<String, AppSign>("sign", Arrays.asList(address, sha3HashOfDataToSign), this.appChainjService, AppSign.class);
    }

    @Override
    public Request<?, AppMetaData> appMetaData(DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, AppMetaData>("getMetaData", Arrays.asList(defaultBlockParameter.getValue()), this.appChainjService, AppMetaData.class);
    }

    @Override
    public Request<?, AppBlockNumber> appBlockNumber() {
        return new Request("blockNumber", Collections.emptyList(), this.appChainjService, AppBlockNumber.class);
    }

    @Override
    public Request<?, AppGetBalance> appGetBalance(String address, DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, AppGetBalance>("getBalance", Arrays.asList(address, defaultBlockParameter.getValue()), this.appChainjService, AppGetBalance.class);
    }

    @Override
    public Request<?, AppGetAbi> appGetAbi(String contractAddress, DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, AppGetAbi>("getAbi", Arrays.asList(contractAddress, defaultBlockParameter.getValue()), this.appChainjService, AppGetAbi.class);
    }

    @Override
    public Request<?, AppGetTransactionCount> appGetTransactionCount(String address, DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, AppGetTransactionCount>("getTransactionCount", Arrays.asList(address, defaultBlockParameter.getValue()), this.appChainjService, AppGetTransactionCount.class);
    }

    @Override
    public Request<?, AppGetCode> appGetCode(String address, DefaultBlockParameter defaultBlockParameter) {
        return new Request<String, AppGetCode>("getCode", Arrays.asList(address, defaultBlockParameter.getValue()), this.appChainjService, AppGetCode.class);
    }

    @Override
    public Request<?, AppSendTransaction> appSendRawTransaction(String signedTransactionData) {
        return new Request<String, AppSendTransaction>("sendRawTransaction", Arrays.asList(signedTransactionData), this.appChainjService, AppSendTransaction.class);
    }

    @Override
    public Request<?, AppCall> appCall(Call call, DefaultBlockParameter defaultBlockParameter) {
        return new Request<Object, AppCall>("call", Arrays.asList(call, defaultBlockParameter), this.appChainjService, AppCall.class);
    }

    @Override
    public Request<?, AppBlock> appGetBlockByHash(String blockHash, boolean returnFullTransactionObjects) {
        return new Request<Serializable, AppBlock>("getBlockByHash", Arrays.asList(blockHash, returnFullTransactionObjects), this.appChainjService, AppBlock.class);
    }

    @Override
    public Request<?, AppBlock> appGetBlockByNumber(DefaultBlockParameter defaultBlockParameter, boolean returnFullTransactionObjects) {
        return new Request<Serializable, AppBlock>("getBlockByNumber", Arrays.asList(defaultBlockParameter.getValue(), returnFullTransactionObjects), this.appChainjService, AppBlock.class);
    }

    @Override
    public Request<?, AppTransaction> appGetTransactionByHash(String transactionHash) {
        return new Request<String, AppTransaction>("getTransaction", Arrays.asList(transactionHash), this.appChainjService, AppTransaction.class);
    }

    @Override
    public Request<?, AppGetTransactionReceipt> appGetTransactionReceipt(String transactionHash) {
        return new Request<String, AppGetTransactionReceipt>("getTransactionReceipt", Arrays.asList(transactionHash), this.appChainjService, AppGetTransactionReceipt.class);
    }

    @Override
    public Request<?, org.nervos.appchain.protocol.core.methods.response.AppFilter> appNewFilter(AppFilter appFilter) {
        return new Request<AppFilter, org.nervos.appchain.protocol.core.methods.response.AppFilter>("newFilter", Arrays.asList(appFilter), this.appChainjService, org.nervos.appchain.protocol.core.methods.response.AppFilter.class);
    }

    @Override
    public Request<?, org.nervos.appchain.protocol.core.methods.response.AppFilter> appNewBlockFilter() {
        return new Request("newBlockFilter", Collections.emptyList(), this.appChainjService, org.nervos.appchain.protocol.core.methods.response.AppFilter.class);
    }

    @Override
    public Request<?, org.nervos.appchain.protocol.core.methods.response.AppFilter> appNewPendingTransactionFilter() {
        return new Request("newPendingTransactionFilter", Collections.emptyList(), this.appChainjService, org.nervos.appchain.protocol.core.methods.response.AppFilter.class);
    }

    @Override
    public Request<?, AppUninstallFilter> appUninstallFilter(BigInteger filterId) {
        return new Request<String, AppUninstallFilter>("uninstallFilter", Arrays.asList(Numeric.encodeQuantity((BigInteger)filterId)), this.appChainjService, AppUninstallFilter.class);
    }

    @Override
    public Request<?, AppLog> appGetFilterChanges(BigInteger filterId) {
        return new Request<String, AppLog>("getFilterChanges", Arrays.asList(Numeric.encodeQuantity((BigInteger)filterId)), this.appChainjService, AppLog.class);
    }

    @Override
    public Request<?, AppLog> appGetFilterLogs(BigInteger filterId) {
        return new Request<String, AppLog>("getFilterLogs", Arrays.asList(Numeric.encodeQuantity((BigInteger)filterId)), this.appChainjService, AppLog.class);
    }

    @Override
    public Request<?, AppLog> appGetLogs(AppFilter appFilter) {
        return new Request<AppFilter, AppLog>("getLogs", Arrays.asList(appFilter), this.appChainjService, AppLog.class);
    }

    @Override
    public Observable<String> appBlockHashObservable() {
        return this.appChainjRx.appBlockHashObservable(this.blockTime);
    }

    @Override
    public Observable<String> appPendingTransactionHashObservable() {
        return this.appChainjRx.appPendingTransactionHashObservable(this.blockTime);
    }

    @Override
    public Observable<Log> appLogObservable(AppFilter appFilter) {
        return this.appChainjRx.appLogObservable(appFilter, this.blockTime);
    }

    @Override
    public Observable<Transaction> transactionObservable() {
        return this.appChainjRx.transactionObservable(this.blockTime);
    }

    @Override
    public Observable<Transaction> pendingTransactionObservable() {
        return this.appChainjRx.pendingTransactionObservable(this.blockTime);
    }

    @Override
    public Observable<AppBlock> blockObservable(boolean fullTransactionObjects) {
        return this.appChainjRx.blockObservable(fullTransactionObjects, this.blockTime);
    }

    @Override
    public Observable<AppBlock> replayBlocksObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects) {
        return this.appChainjRx.replayBlocksObservable(startBlock, endBlock, fullTransactionObjects);
    }

    @Override
    public Observable<AppBlock> replayBlocksObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        return this.appChainjRx.replayBlocksObservable(startBlock, endBlock, fullTransactionObjects, ascending);
    }

    @Override
    public Observable<Transaction> replayTransactionsObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        return this.appChainjRx.replayTransactionsObservable(startBlock, endBlock);
    }

    @Override
    public Observable<AppBlock> catchUpToLatestBlockObservable(DefaultBlockParameter startBlock, boolean fullTransactionObjects, Observable<AppBlock> onCompleteObservable) {
        return this.appChainjRx.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects, onCompleteObservable);
    }

    @Override
    public Observable<AppBlock> catchUpToLatestBlockObservable(DefaultBlockParameter startBlock, boolean fullTransactionObjects) {
        return this.appChainjRx.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects);
    }

    @Override
    public Observable<Transaction> catchUpToLatestTransactionObservable(DefaultBlockParameter startBlock) {
        return this.appChainjRx.catchUpToLatestTransactionObservable(startBlock);
    }

    @Override
    public Observable<AppBlock> catchUpToLatestAndSubscribeToNewBlocksObservable(DefaultBlockParameter startBlock, boolean fullTransactionObjects) {
        return this.appChainjRx.catchUpToLatestAndSubscribeToNewBlocksObservable(startBlock, fullTransactionObjects, this.blockTime);
    }

    @Override
    public Observable<Transaction> catchUpToLatestAndSubscribeToNewTransactionsObservable(DefaultBlockParameter startBlock) {
        return this.appChainjRx.catchUpToLatestAndSubscribeToNewTransactionsObservable(startBlock, this.blockTime);
    }
}

