/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.core.filters;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.protocol.core.Request;
import org.nervos.appchain.protocol.core.filters.Callback;
import org.nervos.appchain.protocol.core.filters.Filter;
import org.nervos.appchain.protocol.core.filters.FilterException;
import org.nervos.appchain.protocol.core.methods.response.AppFilter;
import org.nervos.appchain.protocol.core.methods.response.AppLog;

public class PendingTransactionFilter
extends Filter<String> {
    public PendingTransactionFilter(AppChainj appChainj, Callback<String> callback) {
        super(appChainj, callback);
    }

    @Override
    AppFilter sendRequest() throws IOException {
        return this.appChainj.appNewPendingTransactionFilter().send();
    }

    @Override
    void process(List<AppLog.LogResult> logResults) {
        for (AppLog.LogResult logResult : logResults) {
            if (logResult instanceof AppLog.Hash) {
                String blockHash = ((AppLog.Hash)logResult).get();
                this.callback.onEvent(blockHash);
                continue;
            }
            throw new FilterException("Unexpected result type: " + logResult.get() + ", required Hash");
        }
    }

    @Override
    protected Optional<Request<?, AppLog>> getFilterLogs(BigInteger filterId) {
        return Optional.empty();
    }
}

