/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.rx;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.protocol.core.DefaultBlockParameter;
import org.nervos.appchain.protocol.core.DefaultBlockParameterName;
import org.nervos.appchain.protocol.core.DefaultBlockParameterNumber;
import org.nervos.appchain.protocol.core.filters.BlockFilter;
import org.nervos.appchain.protocol.core.filters.Filter;
import org.nervos.appchain.protocol.core.filters.LogFilter;
import org.nervos.appchain.protocol.core.filters.PendingTransactionFilter;
import org.nervos.appchain.protocol.core.methods.request.AppFilter;
import org.nervos.appchain.protocol.core.methods.response.AppBlock;
import org.nervos.appchain.protocol.core.methods.response.Log;
import org.nervos.appchain.protocol.core.methods.response.Transaction;
import org.nervos.appchain.utils.Observables;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.schedulers.Schedulers;
import rx.subscriptions.Subscriptions;

public class JsonRpc2_0Rx {
    private final AppChainj appChainj;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Scheduler scheduler;

    public JsonRpc2_0Rx(AppChainj appChainj, ScheduledExecutorService scheduledExecutorService) {
        this.appChainj = appChainj;
        this.scheduledExecutorService = scheduledExecutorService;
        this.scheduler = Schedulers.from((Executor)scheduledExecutorService);
    }

    public Observable<String> appBlockHashObservable(long pollingInterval) {
        return Observable.create(subscriber -> {
            BlockFilter blockFilter = new BlockFilter(this.appChainj, arg_0 -> ((Subscriber)subscriber).onNext(arg_0));
            this.run(blockFilter, (Subscriber)subscriber, pollingInterval);
        });
    }

    public Observable<String> appPendingTransactionHashObservable(long pollingInterval) {
        return Observable.create(subscriber -> {
            PendingTransactionFilter pendingTransactionFilter = new PendingTransactionFilter(this.appChainj, arg_0 -> ((Subscriber)subscriber).onNext(arg_0));
            this.run(pendingTransactionFilter, (Subscriber)subscriber, pollingInterval);
        });
    }

    public Observable<Log> appLogObservable(AppFilter appFilter, long pollingInterval) {
        return Observable.create(subscriber -> {
            LogFilter logFilter = new LogFilter(this.appChainj, arg_0 -> ((Subscriber)subscriber).onNext(arg_0), appFilter);
            this.run(logFilter, (Subscriber)subscriber, pollingInterval);
        });
    }

    private <T> void run(Filter<T> filter, Subscriber<? super T> subscriber, long pollingInterval) {
        filter.run(this.scheduledExecutorService, pollingInterval);
        subscriber.add(Subscriptions.create(filter::cancel));
    }

    public Observable<Transaction> transactionObservable(long pollingInterval) {
        return this.blockObservable(true, pollingInterval).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Observable<Transaction> pendingTransactionObservable(long pollingInterval) {
        return this.appPendingTransactionHashObservable(pollingInterval).flatMap(transactionHash -> this.appChainj.appGetTransactionByHash((String)transactionHash).observable()).map(appTransaction -> appTransaction.getTransaction().get());
    }

    public Observable<AppBlock> blockObservable(boolean fullTransactionObjects, long pollingInterval) {
        return this.appBlockHashObservable(pollingInterval).flatMap(blockHash -> this.appChainj.appGetBlockByHash((String)blockHash, fullTransactionObjects).observable());
    }

    public Observable<AppBlock> replayBlocksObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects) {
        return this.replayBlocksObservable(startBlock, endBlock, fullTransactionObjects, true);
    }

    public Observable<AppBlock> replayBlocksObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        return this.replayBlocksObservableSync(startBlock, endBlock, fullTransactionObjects, ascending).subscribeOn(this.scheduler);
    }

    private Observable<AppBlock> replayBlocksObservableSync(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects) {
        return this.replayBlocksObservableSync(startBlock, endBlock, fullTransactionObjects, true);
    }

    private Observable<AppBlock> replayBlocksObservableSync(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        BigInteger startBlockNumber = null;
        BigInteger endBlockNumber = null;
        try {
            startBlockNumber = this.getBlockNumber(startBlock);
            endBlockNumber = this.getBlockNumber(endBlock);
        }
        catch (IOException e) {
            Observable.error((Throwable)e);
        }
        if (ascending) {
            return Observables.range(startBlockNumber, endBlockNumber).flatMap(i -> this.appChainj.appGetBlockByNumber(new DefaultBlockParameterNumber((BigInteger)i), fullTransactionObjects).observable());
        }
        return Observables.range(startBlockNumber, endBlockNumber, false).flatMap(i -> this.appChainj.appGetBlockByNumber(new DefaultBlockParameterNumber((BigInteger)i), fullTransactionObjects).observable());
    }

    public Observable<Transaction> replayTransactionsObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        return this.replayBlocksObservable(startBlock, endBlock, true).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Observable<AppBlock> catchUpToLatestBlockObservable(DefaultBlockParameter startBlock, boolean fullTransactionObjects, Observable<AppBlock> onCompleteObservable) {
        return this.catchUpToLatestBlockObservableSync(startBlock, fullTransactionObjects, onCompleteObservable).subscribeOn(this.scheduler);
    }

    public Observable<AppBlock> catchUpToLatestBlockObservable(DefaultBlockParameter startBlock, boolean fullTransactionObjects) {
        return this.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects, (Observable<AppBlock>)Observable.empty());
    }

    private Observable<AppBlock> catchUpToLatestBlockObservableSync(DefaultBlockParameter startBlock, boolean fullTransactionObjects, Observable<AppBlock> onCompleteObservable) {
        BigInteger latestBlockNumber;
        BigInteger startBlockNumber;
        try {
            startBlockNumber = this.getBlockNumber(startBlock);
            latestBlockNumber = this.getLatestBlockNumber();
        }
        catch (IOException e) {
            return Observable.error((Throwable)e);
        }
        if (startBlockNumber.compareTo(latestBlockNumber) > -1) {
            return onCompleteObservable;
        }
        return Observable.concat(this.replayBlocksObservableSync(new DefaultBlockParameterNumber(startBlockNumber), new DefaultBlockParameterNumber(latestBlockNumber), fullTransactionObjects), (Observable)Observable.defer(() -> this.catchUpToLatestBlockObservableSync(new DefaultBlockParameterNumber(latestBlockNumber.add(BigInteger.ONE)), fullTransactionObjects, onCompleteObservable)));
    }

    public Observable<Transaction> catchUpToLatestTransactionObservable(DefaultBlockParameter startBlock) {
        return this.catchUpToLatestBlockObservable(startBlock, true, (Observable<AppBlock>)Observable.empty()).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    public Observable<AppBlock> catchUpToLatestAndSubscribeToNewBlocksObservable(DefaultBlockParameter startBlock, boolean fullTransactionObjects, long pollingInterval) {
        return this.catchUpToLatestBlockObservable(startBlock, fullTransactionObjects, this.blockObservable(fullTransactionObjects, pollingInterval));
    }

    public Observable<Transaction> catchUpToLatestAndSubscribeToNewTransactionsObservable(DefaultBlockParameter startBlock, long pollingInterval) {
        return this.catchUpToLatestAndSubscribeToNewBlocksObservable(startBlock, true, pollingInterval).flatMapIterable(JsonRpc2_0Rx::toTransactions);
    }

    private BigInteger getLatestBlockNumber() throws IOException {
        return this.getBlockNumber(DefaultBlockParameterName.LATEST);
    }

    private BigInteger getBlockNumber(DefaultBlockParameter defaultBlockParameter) throws IOException {
        if (defaultBlockParameter instanceof DefaultBlockParameterNumber) {
            return ((DefaultBlockParameterNumber)defaultBlockParameter).getBlockNumber();
        }
        AppBlock latestEthBlock = this.appChainj.appGetBlockByNumber(defaultBlockParameter, false).send();
        return latestEthBlock.getBlock().getHeader().getNumberDec();
    }

    private static List<Transaction> toTransactions(AppBlock appBlock) {
        return appBlock.getBlock().getBody().getTransactions().stream().map(transactionResult -> transactionResult.get()).collect(Collectors.toList());
    }
}

