/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.system;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.nervos.appchain.abi.FunctionEncoder;
import org.nervos.appchain.abi.FunctionReturnDecoder;
import org.nervos.appchain.abi.TypeReference;
import org.nervos.appchain.abi.datatypes.Address;
import org.nervos.appchain.abi.datatypes.DynamicArray;
import org.nervos.appchain.abi.datatypes.Function;
import org.nervos.appchain.abi.datatypes.NumericType;
import org.nervos.appchain.abi.datatypes.Type;
import org.nervos.appchain.abi.datatypes.Uint;
import org.nervos.appchain.abi.datatypes.generated.Uint64;
import org.nervos.appchain.abi.datatypes.generated.Uint8;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.protocol.core.methods.request.Transaction;
import org.nervos.appchain.protocol.core.methods.response.AppCall;
import org.nervos.appchain.protocol.core.methods.response.AppSendTransaction;
import org.nervos.appchain.protocol.core.methods.response.Log;
import org.nervos.appchain.protocol.core.methods.response.TransactionReceipt;
import org.nervos.appchain.protocol.system.AppChainSystemAddress;
import org.nervos.appchain.protocol.system.AppChainSystemContract;
import org.nervos.appchain.protocol.system.Util;

public class AppChainjSystemContract
implements AppChainSystemContract,
AppChainSystemAddress {
    private AppChainj service;

    public AppChainjSystemContract(AppChainj service) {
        this.service = service;
    }

    public List<String> listNode(String from) throws IOException {
        String callData = AppChainSystemContract.encodeCall("listNode");
        AppCall callResult = AppChainSystemContract.sendCall(from, "0xffffffffffffffffffffffffffffffffff020001", callData, this.service);
        List resultTypes = FunctionReturnDecoder.decode((String)callResult.getValue(), AppChainSystemContract.convert(Arrays.asList(new TypeReference<DynamicArray<Address>>(){})));
        ArrayList results = (ArrayList)((Type)resultTypes.get(0)).getValue();
        return results.stream().map(Address::getValue).collect(Collectors.toList());
    }

    public int getStatus(String from) throws IOException {
        Function callFunc = new Function("getStatus", Arrays.asList(new Address(from)), Collections.emptyList());
        FunctionEncoder.encode((Function)callFunc);
        AppCall callResult = AppChainSystemContract.sendCall(from, "0xffffffffffffffffffffffffffffffffff020001", FunctionEncoder.encode((Function)callFunc), this.service);
        List resultTypes = FunctionReturnDecoder.decode((String)callResult.getValue(), AppChainSystemContract.convert(Arrays.asList(new TypeReference<Uint8>(){})));
        if (resultTypes.get(0) == null) {
            throw new NullPointerException("No info for address: " + from + ". Maybe it is not in correct format.");
        }
        return Integer.parseInt(((Type)resultTypes.get(0)).getValue().toString());
    }

    public List<BigInteger> listStake(String from) throws IOException {
        String callData = AppChainSystemContract.encodeCall("listStake");
        AppCall callResult = AppChainSystemContract.sendCall(from, "0xffffffffffffffffffffffffffffffffff020001", callData, this.service);
        List resultTypes = FunctionReturnDecoder.decode((String)callResult.getValue(), AppChainSystemContract.convert(Arrays.asList(new TypeReference<DynamicArray<Uint64>>(){})));
        ArrayList results = (ArrayList)((Type)resultTypes.get(0)).getValue();
        return results.stream().map(NumericType::getValue).collect(Collectors.toList());
    }

    public int stakePermillage(String from) throws IOException {
        Function callFunc = new Function("stakePermillage", Arrays.asList(new Address(from)), Collections.emptyList());
        AppCall callResult = AppChainSystemContract.sendCall(from, "0xffffffffffffffffffffffffffffffffff020001", FunctionEncoder.encode((Function)callFunc), this.service);
        List resultTypes = FunctionReturnDecoder.decode((String)callResult.getValue(), AppChainSystemContract.convert(Arrays.asList(new TypeReference<Uint64>(){})));
        return Integer.parseInt(((Type)resultTypes.get(0)).getValue().toString());
    }

    @Override
    public int getQuotaPrice(String from) throws IOException {
        String callData = AppChainSystemContract.encodeCall("getQuotaPrice");
        AppCall callResult = AppChainSystemContract.sendCall(from, "0xffffffffffffffffffffffffffffffffff020010", callData, this.service);
        List resultTypes = FunctionReturnDecoder.decode((String)callResult.getValue(), AppChainSystemContract.convert(Arrays.asList(new TypeReference<Uint>(){})));
        return Integer.parseInt(((Type)resultTypes.get(0)).getValue().toString());
    }

    public boolean approveNode(String nodeAddr, String adminPrivatekey) throws IOException, InterruptedException {
        Function func = new Function("approveNode", Arrays.asList(new Address(nodeAddr)), Collections.emptyList());
        String funcData = FunctionEncoder.encode((Function)func);
        Long validUtilBlock = Util.getValidUtilBlock(this.service).longValue();
        Transaction tx = new Transaction("0xffffffffffffffffffffffffffffffffff020001", Util.getNonce(), 10000000L, validUtilBlock, 0, 1, "0", funcData);
        String signedTx = tx.sign(adminPrivatekey);
        AppSendTransaction appTx = this.service.appSendRawTransaction(signedTx).send();
        if (appTx.getError() != null) {
            String message = appTx.getError().getMessage();
            System.out.println("Failed to add approve node(" + nodeAddr + "). Error message: " + message);
            return false;
        }
        String txHash = appTx.getSendTransactionResult().getHash();
        int count = 0;
        do {
            Optional<TransactionReceipt> receipt;
            if ((receipt = this.service.appGetTransactionReceipt(txHash).send().getTransactionReceipt()).isPresent()) {
                TransactionReceipt txReceipt = receipt.get();
                if (txReceipt.getErrorMessage() != null) {
                    return false;
                }
                List<Log> logs = txReceipt.getLogs();
                String toCompare = Util.addUpTo64Hex(nodeAddr);
                return logs.get(0).getTopics().contains(toCompare);
            }
            TimeUnit.SECONDS.sleep(3L);
        } while (++count <= 5);
        return false;
    }

    public boolean deleteNode(String nodeAddr, String adminPrivatekey) throws IOException, InterruptedException {
        Function func = new Function("deleteNode", Arrays.asList(new Address(nodeAddr)), Collections.emptyList());
        String funcData = FunctionEncoder.encode((Function)func);
        Long validUtilBlock = Util.getValidUtilBlock(this.service).longValue();
        Transaction tx = new Transaction("0xffffffffffffffffffffffffffffffffff020001", Util.getNonce(), 10000000L, validUtilBlock, 0, 1, "0", funcData);
        String signedTx = tx.sign(adminPrivatekey);
        AppSendTransaction appSendTransaction = this.service.appSendRawTransaction(signedTx).send();
        if (appSendTransaction.getError() != null) {
            String message = appSendTransaction.getError().getMessage();
            System.out.println("Failed to add delete node(" + nodeAddr + "). Error message: " + message);
            return false;
        }
        String txHash = appSendTransaction.getSendTransactionResult().getHash();
        int count = 0;
        do {
            Optional<TransactionReceipt> receipt;
            if ((receipt = this.service.appGetTransactionReceipt(txHash).send().getTransactionReceipt()).isPresent()) {
                TransactionReceipt txReceipt = receipt.get();
                if (txReceipt.getErrorMessage() != null) {
                    return false;
                }
                List<Log> logs = txReceipt.getLogs();
                String toCompare = Util.addUpTo64Hex(nodeAddr);
                return logs.get(0).getTopics().contains(toCompare);
            }
            TimeUnit.SECONDS.sleep(3L);
        } while (++count <= 5);
        return false;
    }

    public boolean setStake(String nodeAddr, int stake, String adminPrivatekey) throws IOException, InterruptedException {
        Function func = new Function("setStake", Arrays.asList(new Address(nodeAddr), new Uint64((long)stake)), Collections.emptyList());
        String funcData = FunctionEncoder.encode((Function)func);
        Long validUtilBlock = Util.getValidUtilBlock(this.service).longValue();
        Transaction tx = new Transaction("0xffffffffffffffffffffffffffffffffff020001", Util.getNonce(), 10000000L, validUtilBlock, 0, 1, "0", funcData);
        String rawTx = tx.sign(adminPrivatekey);
        AppSendTransaction appSendTransaction = this.service.appSendRawTransaction(rawTx).send();
        if (appSendTransaction.getError() != null) {
            String message = appSendTransaction.getError().getMessage();
            System.out.println("Failed to set stake " + stake + " for node(" + nodeAddr + "). Error message: " + message);
            return false;
        }
        String txHash = appSendTransaction.getSendTransactionResult().getHash();
        int count = 0;
        do {
            Optional<TransactionReceipt> receipt;
            if ((receipt = this.service.appGetTransactionReceipt(txHash).send().getTransactionReceipt()).isPresent()) {
                TransactionReceipt txReceipt = receipt.get();
                if (txReceipt.getErrorMessage() != null) {
                    return false;
                }
                List<Log> logs = txReceipt.getLogs();
                String nodeAddrToCompare = Util.addUpTo64Hex(nodeAddr);
                return logs.get(0).getTopics().contains(nodeAddrToCompare);
            }
            TimeUnit.SECONDS.sleep(3L);
        } while (++count <= 5);
        return false;
    }

    public Transaction constructStoreTransaction(String data, int version, int chainId) {
        Transaction tx = new Transaction("0xffffffffffffffffffffffffffffffffff010000", Util.getNonce(), DEFAULT_QUOTA, Util.getValidUtilBlock(this.service).longValue(), version, chainId, "0", data);
        return tx;
    }
}

