/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.protocol.system;

import java.math.BigInteger;
import java.util.Random;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.utils.Numeric;

public class Util {
    static String getNonce() {
        Random random = new Random(System.currentTimeMillis());
        return String.valueOf(Math.abs(random.nextLong()));
    }

    static BigInteger getCurrentHeight(AppChainj service) {
        return Util.getCurrentHeight(service, 3);
    }

    private static BigInteger getCurrentHeight(AppChainj service, int retry) {
        int count;
        long height = -1L;
        for (count = 0; count < retry; ++count) {
            try {
                height = service.appBlockNumber().send().getBlockNumber().longValue();
                continue;
            }
            catch (Exception e) {
                height = -1L;
                System.out.println("getBlockNumber failed retry ..");
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (Exception e1) {
                    System.out.println("failed to get block number, Exception: " + e1);
                    System.exit(1);
                }
            }
        }
        if (height == -1L) {
            System.out.println("Failed to get block number after " + count + " times.");
            System.exit(1);
        }
        return BigInteger.valueOf(height);
    }

    static BigInteger getValidUtilBlock(AppChainj service, int validUntilBlock) {
        return Util.getCurrentHeight(service).add(BigInteger.valueOf(validUntilBlock));
    }

    static BigInteger getValidUtilBlock(AppChainj service) {
        return Util.getCurrentHeight(service).add(BigInteger.valueOf(88L));
    }

    static String addUpTo64Hex(String hexStr) {
        String result = Numeric.cleanHexPrefix((String)hexStr);
        int len = 64 - result.length();
        for (int i = 0; i < len; ++i) {
            result = "0" + result;
        }
        return Numeric.prependHexPrefix((String)result);
    }
}

