/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.tx;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.nervos.appchain.abi.EventEncoder;
import org.nervos.appchain.abi.EventValues;
import org.nervos.appchain.abi.FunctionEncoder;
import org.nervos.appchain.abi.FunctionReturnDecoder;
import org.nervos.appchain.abi.TypeReference;
import org.nervos.appchain.abi.datatypes.Address;
import org.nervos.appchain.abi.datatypes.Event;
import org.nervos.appchain.abi.datatypes.Function;
import org.nervos.appchain.abi.datatypes.Type;
import org.nervos.appchain.crypto.Credentials;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.protocol.core.DefaultBlockParameterName;
import org.nervos.appchain.protocol.core.RemoteCall;
import org.nervos.appchain.protocol.core.methods.request.Call;
import org.nervos.appchain.protocol.core.methods.response.AppCall;
import org.nervos.appchain.protocol.core.methods.response.AppGetCode;
import org.nervos.appchain.protocol.core.methods.response.Log;
import org.nervos.appchain.protocol.core.methods.response.TransactionReceipt;
import org.nervos.appchain.protocol.exceptions.TransactionException;
import org.nervos.appchain.tx.ManagedTransaction;
import org.nervos.appchain.tx.RawTransactionManager;
import org.nervos.appchain.tx.TransactionManager;
import org.nervos.appchain.tx.exceptions.ContractCallException;
import org.nervos.appchain.utils.Numeric;

public abstract class Contract
extends ManagedTransaction {
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(4300000L);
    protected final String contractBinary;
    protected String contractAddress;
    protected BigInteger gasPrice;
    protected BigInteger gasLimit;
    protected TransactionReceipt transactionReceipt;
    protected Map<String, String> deployedAddresses;

    protected Contract(String contractBinary, String contractAddress, AppChainj appChainj, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(appChainj, transactionManager);
        this.contractAddress = contractAddress;
        this.contractBinary = contractBinary;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
    }

    protected Contract(String contractBinary, String contractAddress, AppChainj appChainj, TransactionManager transactionManager) {
        this(contractBinary, contractAddress, appChainj, transactionManager, BigInteger.ZERO, BigInteger.ZERO);
    }

    protected Contract(String contractBinary, String contractAddress, AppChainj appChainj, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        this(contractBinary, contractAddress, appChainj, new RawTransactionManager(appChainj, credentials), gasPrice, gasLimit);
    }

    @Deprecated
    protected Contract(String contractAddress, AppChainj appChainj, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        this("", contractAddress, appChainj, transactionManager, gasPrice, gasLimit);
    }

    @Deprecated
    protected Contract(String contractAddress, AppChainj appChainj, TransactionManager transactionManager) {
        this("", contractAddress, appChainj, transactionManager, BigInteger.ZERO, BigInteger.ZERO);
    }

    @Deprecated
    protected Contract(String contractAddress, AppChainj appChainj, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        this("", contractAddress, appChainj, new RawTransactionManager(appChainj, credentials), gasPrice, gasLimit);
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setTransactionReceipt(TransactionReceipt transactionReceipt) {
        this.transactionReceipt = transactionReceipt;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }

    public boolean isValid() throws IOException {
        if (this.contractAddress.equals("")) {
            throw new UnsupportedOperationException("Contract binary not present, you will need to regenerate your smart contract wrapper with appChainj v2.2.0+");
        }
        AppGetCode ethGetCode = this.appChainj.appGetCode(this.contractAddress, DefaultBlockParameterName.LATEST).send();
        if (ethGetCode.hasError()) {
            return false;
        }
        String code = Numeric.cleanHexPrefix((String)ethGetCode.getCode());
        return !code.isEmpty() && this.contractBinary.contains(code);
    }

    public Optional<TransactionReceipt> getTransactionReceipt() {
        return Optional.ofNullable(this.transactionReceipt);
    }

    private List<Type> executeCall(Function function) throws IOException {
        String encodedFunction = FunctionEncoder.encode((Function)function);
        AppCall ethCall = this.appChainj.appCall(new Call(this.transactionManager.getFromAddress(), this.contractAddress, encodedFunction), DefaultBlockParameterName.LATEST).send();
        String value = ethCall.getValue();
        return FunctionReturnDecoder.decode((String)value, (List)function.getOutputParameters());
    }

    protected <T extends Type> T executeCallSingleValueReturn(Function function) throws IOException {
        List<Type> values = this.executeCall(function);
        if (!values.isEmpty()) {
            return (T)values.get(0);
        }
        return null;
    }

    protected <T extends Type, R> R executeCallSingleValueReturn(Function function, Class<R> returnType) throws IOException {
        T result = this.executeCallSingleValueReturn(function);
        if (result == null) {
            throw new ContractCallException("Empty value (0x) returned from contract");
        }
        Object value = result.getValue();
        if (returnType.isAssignableFrom(value.getClass())) {
            return (R)value;
        }
        if (result.getClass().equals(Address.class) && returnType.equals(String.class)) {
            return (R)result.toString();
        }
        throw new ContractCallException("Unable to convert response: " + value + " to expected type: " + returnType.getSimpleName());
    }

    protected List<Type> executeCallMultipleValueReturn(Function function) throws IOException {
        return this.executeCall(function);
    }

    protected TransactionReceipt executeTransaction(Function function) throws IOException, TransactionException {
        return this.executeTransaction(function, "0");
    }

    private TransactionReceipt executeTransaction(Function function, String weiValue) throws IOException, TransactionException {
        return this.executeTransaction(FunctionEncoder.encode((Function)function), weiValue);
    }

    TransactionReceipt executeTransaction(String data, String weiValue) throws TransactionException, IOException {
        return this.send(this.contractAddress, data, weiValue, this.gasPrice, this.gasLimit);
    }

    TransactionReceipt executeTransaction(String data, long quota, String nonce, long validUntilBlock, int version, int chainId, String value) throws TransactionException, IOException {
        return this.sendAdaptToCita(this.contractAddress, data, quota, nonce, validUntilBlock, version, chainId, value);
    }

    protected <T extends Type> RemoteCall<T> executeRemoteCallSingleValueReturn(Function function) {
        return new RemoteCall<Type>(() -> this.executeCallSingleValueReturn(function));
    }

    protected <T> RemoteCall<T> executeRemoteCallSingleValueReturn(Function function, Class<T> returnType) {
        return new RemoteCall<Object>(() -> this.executeCallSingleValueReturn(function, returnType));
    }

    protected RemoteCall<List<Type>> executeRemoteCallMultipleValueReturn(Function function) {
        return new RemoteCall<List<Type>>(() -> this.executeCallMultipleValueReturn(function));
    }

    protected RemoteCall<TransactionReceipt> executeRemoteCallTransaction(Function function) {
        return new RemoteCall<TransactionReceipt>(() -> this.executeTransaction(function));
    }

    protected RemoteCall<TransactionReceipt> executeRemoteCallTransaction(Function function, String weiValue) {
        return new RemoteCall<TransactionReceipt>(() -> this.executeTransaction(function, weiValue));
    }

    protected RemoteCall<TransactionReceipt> executeRemoteCallTransaction(Function function, long quota, String nonce, long validUntilBlock, int version, int chainId, String value) {
        return new RemoteCall<TransactionReceipt>(() -> this.executeTransaction(FunctionEncoder.encode((Function)function), quota, nonce, validUntilBlock, version, chainId, value));
    }

    private static <T extends Contract> T create(T contract, String binary, String encodedConstructor, String value) throws IOException, TransactionException {
        TransactionReceipt transactionReceipt = contract.executeTransaction(binary + encodedConstructor, value);
        String contractAddress = transactionReceipt.getContractAddress();
        if (contractAddress == null) {
            throw new RuntimeException("Empty contract address returned");
        }
        contract.setContractAddress(contractAddress);
        contract.setTransactionReceipt(transactionReceipt);
        return contract;
    }

    private static <T extends Contract> T create(T contract, String binary, String encodedConstructor, long quota, String nonce, long validUntilBlock, int version, int chainId, String value) throws IOException, TransactionException {
        TransactionReceipt transactionReceipt = contract.executeTransaction(binary + encodedConstructor, quota, nonce, validUntilBlock, version, chainId, value);
        String contractAddress = transactionReceipt.getContractAddress();
        if (contractAddress == null) {
            throw new RuntimeException("Empty contract address returned");
        }
        contract.setContractAddress(contractAddress);
        contract.setTransactionReceipt(transactionReceipt);
        return contract;
    }

    protected static <T extends Contract> T deploy(Class<T> type, AppChainj appChainj, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, String value) throws IOException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, AppChainj.class, Credentials.class, BigInteger.class, BigInteger.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance(null, appChainj, credentials, gasPrice, gasLimit);
            return (T)Contract.create(contract, binary, encodedConstructor, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends Contract> T deploy(Class<T> type, AppChainj appChainj, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, String value) throws IOException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, AppChainj.class, TransactionManager.class, BigInteger.class, BigInteger.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance("", appChainj, transactionManager, gasPrice, gasLimit);
            return (T)Contract.create(contract, binary, encodedConstructor, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends Contract> T deploy(Class<T> type, AppChainj appChainj, TransactionManager transactionManager, long quota, String nonce, long validUntilBlock, int version, String binary, int chainId, String value, String encodedConstructor) throws IOException, TransactionException {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(String.class, AppChainj.class, TransactionManager.class);
            constructor.setAccessible(true);
            Contract contract = (Contract)constructor.newInstance("", appChainj, transactionManager);
            return (T)Contract.create(contract, binary, encodedConstructor, quota, nonce, validUntilBlock, version, chainId, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, AppChainj appChainj, TransactionManager transactionManager, long quota, String nonce, long validUntilBlock, int version, int chainId, String value, String binary, String encodedConstructor) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, appChainj, transactionManager, quota, nonce, validUntilBlock, version, binary, chainId, value, encodedConstructor));
    }

    protected static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, AppChainj appChainj, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, String value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, appChainj, credentials, gasPrice, gasLimit, binary, encodedConstructor, value));
    }

    protected static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, AppChainj appChainj, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor) {
        return Contract.deployRemoteCall(type, appChainj, credentials, gasPrice, gasLimit, binary, encodedConstructor, "0");
    }

    protected static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, AppChainj appChainj, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor, String value) {
        return new RemoteCall<Contract>(() -> Contract.deploy(type, appChainj, transactionManager, gasPrice, gasLimit, binary, encodedConstructor, value));
    }

    protected static <T extends Contract> RemoteCall<T> deployRemoteCall(Class<T> type, AppChainj appChainj, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String binary, String encodedConstructor) {
        return Contract.deployRemoteCall(type, appChainj, transactionManager, gasPrice, gasLimit, binary, encodedConstructor, "0");
    }

    public static EventValues staticExtractEventParameters(Event event, Log log) {
        List<String> topics = log.getTopics();
        String encodedEventSignature = EventEncoder.encode((Event)event);
        if (!topics.get(0).equals(encodedEventSignature)) {
            return null;
        }
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        List nonIndexedValues = FunctionReturnDecoder.decode((String)log.getData(), (List)event.getNonIndexedParameters());
        List indexedParameters = event.getIndexedParameters();
        for (int i = 0; i < indexedParameters.size(); ++i) {
            Type value = FunctionReturnDecoder.decodeIndexedValue((String)topics.get(i + 1), (TypeReference)((TypeReference)indexedParameters.get(i)));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }

    protected EventValues extractEventParameters(Event event, Log log) {
        return Contract.staticExtractEventParameters(event, log);
    }

    protected List<EventValues> extractEventParameters(Event event, TransactionReceipt transactionReceipt) {
        List<Log> logs = transactionReceipt.getLogs();
        ArrayList<EventValues> values = new ArrayList<EventValues>();
        for (Log log : logs) {
            EventValues eventValues = this.extractEventParameters(event, log);
            if (eventValues == null) continue;
            values.add(eventValues);
        }
        return values;
    }

    protected String getStaticDeployedAddress(String networkId) {
        return null;
    }

    public final void setDeployedAddress(String networkId, String address) {
        if (this.deployedAddresses == null) {
            this.deployedAddresses = new HashMap<String, String>();
        }
        this.deployedAddresses.put(networkId, address);
    }

    public final String getDeployedAddress(String networkId) {
        String addr = null;
        if (this.deployedAddresses != null) {
            addr = this.deployedAddresses.get(networkId);
        }
        return addr == null ? this.getStaticDeployedAddress(networkId) : addr;
    }

    protected static <S extends Type, T> List<T> convertToNative(List<S> arr) {
        ArrayList<Object> out = new ArrayList<Object>();
        Iterator<S> it = arr.iterator();
        while (it.hasNext()) {
            out.add(((Type)it.next()).getValue());
        }
        return out;
    }
}

