/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.tx;

import java.io.IOException;
import java.math.BigInteger;
import org.nervos.appchain.crypto.Credentials;
import org.nervos.appchain.crypto.RawTransaction;
import org.nervos.appchain.crypto.TransactionEncoder;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.protocol.core.DefaultBlockParameterName;
import org.nervos.appchain.protocol.core.methods.response.AppGetTransactionCount;
import org.nervos.appchain.protocol.core.methods.response.AppSendTransaction;
import org.nervos.appchain.tx.TransactionManager;
import org.nervos.appchain.tx.response.TransactionReceiptProcessor;
import org.nervos.appchain.utils.Numeric;

public class RawTransactionManager
extends TransactionManager {
    private final AppChainj appChainj;
    final Credentials credentials;
    private final byte chainId;

    public RawTransactionManager(AppChainj appChainj, Credentials credentials, byte chainId) {
        super(appChainj, credentials.getAddress());
        this.appChainj = appChainj;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(AppChainj appChainj, Credentials credentials, byte chainId, TransactionReceiptProcessor transactionReceiptProcessor) {
        super(transactionReceiptProcessor, credentials.getAddress());
        this.appChainj = appChainj;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(AppChainj appChainj, Credentials credentials, byte chainId, int attempts, long sleepDuration) {
        super(appChainj, attempts, sleepDuration, credentials.getAddress());
        this.appChainj = appChainj;
        this.credentials = credentials;
        this.chainId = chainId;
    }

    public RawTransactionManager(AppChainj appChainj, Credentials credentials) {
        this(appChainj, credentials, -1);
    }

    public RawTransactionManager(AppChainj appChainj, Credentials credentials, int attempts, int sleepDuration) {
        this(appChainj, credentials, -1, attempts, sleepDuration);
    }

    protected BigInteger getNonce() throws IOException {
        AppGetTransactionCount ethGetTransactionCount = this.appChainj.appGetTransactionCount(this.credentials.getAddress(), DefaultBlockParameterName.PENDING).send();
        return ethGetTransactionCount.getTransactionCount();
    }

    @Override
    public AppSendTransaction sendTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, String value) throws IOException {
        BigInteger nonce = this.getNonce();
        RawTransaction rawTransaction = RawTransaction.createTransaction((BigInteger)nonce, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)to, (String)value, (String)data);
        return this.signAndSend(rawTransaction);
    }

    public AppSendTransaction signAndSend(RawTransaction rawTransaction) throws IOException {
        byte[] signedMessage = this.chainId > -1 ? TransactionEncoder.signMessage((RawTransaction)rawTransaction, (byte)this.chainId, (Credentials)this.credentials) : TransactionEncoder.signMessage((RawTransaction)rawTransaction, (Credentials)this.credentials);
        String hexValue = Numeric.toHexString((byte[])signedMessage);
        return this.appChainj.appSendRawTransaction(hexValue).send();
    }
}

