/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.tx;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.nervos.appchain.crypto.Credentials;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.protocol.core.RemoteCall;
import org.nervos.appchain.protocol.core.methods.response.TransactionReceipt;
import org.nervos.appchain.protocol.exceptions.TransactionException;
import org.nervos.appchain.tx.ManagedTransaction;
import org.nervos.appchain.tx.RawTransactionManager;
import org.nervos.appchain.tx.TransactionManager;
import org.nervos.appchain.utils.Convert;
import org.nervos.appchain.utils.Numeric;

public class Transfer
extends ManagedTransaction {
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(21000L);

    public Transfer(AppChainj appChainj, TransactionManager transactionManager) {
        super(appChainj, transactionManager);
    }

    private TransactionReceipt send(String toAddress, BigDecimal value, Convert.Unit unit) throws IOException, InterruptedException, TransactionException {
        BigInteger gasPrice = BigInteger.valueOf(1L);
        return this.send(toAddress, value, unit, gasPrice, GAS_LIMIT);
    }

    private TransactionReceipt send(String toAddress, BigDecimal value, Convert.Unit unit, BigInteger gasPrice, BigInteger gasLimit) throws IOException, InterruptedException, TransactionException {
        BigDecimal weiValue = Convert.toWei((BigDecimal)value, (Convert.Unit)unit);
        if (!Numeric.isIntegerValue((BigDecimal)weiValue)) {
            throw new UnsupportedOperationException("Non decimal Wei value provided: " + value + " " + unit.toString() + " = " + weiValue + " Wei");
        }
        return this.send(toAddress, "", String.valueOf(weiValue.toBigIntegerExact()), gasPrice, gasLimit);
    }

    public static RemoteCall<TransactionReceipt> sendFunds(AppChainj appChainj, Credentials credentials, String toAddress, BigDecimal value, Convert.Unit unit) throws InterruptedException, IOException, TransactionException {
        RawTransactionManager transactionManager = new RawTransactionManager(appChainj, credentials);
        return new RemoteCall<TransactionReceipt>(() -> new Transfer(appChainj, transactionManager).send(toAddress, value, unit));
    }

    public RemoteCall<TransactionReceipt> sendFunds(String toAddress, BigDecimal value, Convert.Unit unit) {
        return new RemoteCall<TransactionReceipt>(() -> this.send(toAddress, value, unit));
    }

    public RemoteCall<TransactionReceipt> sendFunds(String toAddress, BigDecimal value, Convert.Unit unit, BigInteger gasPrice, BigInteger gasLimit) {
        return new RemoteCall<TransactionReceipt>(() -> this.send(toAddress, value, unit, gasPrice, gasLimit));
    }
}

