/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.tx.response;

import java.io.IOException;
import java.util.Optional;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.protocol.core.methods.response.TransactionReceipt;
import org.nervos.appchain.protocol.exceptions.TransactionException;
import org.nervos.appchain.tx.response.TransactionReceiptProcessor;

public class PollingTransactionReceiptProcessor
extends TransactionReceiptProcessor {
    private final long sleepDuration;
    private final int attempts;

    public PollingTransactionReceiptProcessor(AppChainj appChainj, long sleepDuration, int attempts) {
        super(appChainj);
        this.sleepDuration = sleepDuration;
        this.attempts = attempts;
    }

    @Override
    public TransactionReceipt waitForTransactionReceipt(String transactionHash) throws IOException, TransactionException {
        return this.getTransactionReceipt(transactionHash, this.sleepDuration, this.attempts);
    }

    private TransactionReceipt getTransactionReceipt(String transactionHash, long sleepDuration, int attempts) throws IOException, TransactionException {
        Optional<TransactionReceipt> receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        for (int i = 0; i < attempts; ++i) {
            if (!receiptOptional.isPresent()) {
                try {
                    Thread.sleep(sleepDuration);
                }
                catch (InterruptedException e) {
                    throw new TransactionException(e);
                }
            } else {
                return receiptOptional.get();
            }
            receiptOptional = this.sendTransactionReceiptRequest(transactionHash);
        }
        throw new TransactionException("Transaction receipt was not generated after " + sleepDuration * (long)attempts / 1000L + " seconds for transaction: " + transactionHash);
    }
}

