/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.tx.response;

import java.io.IOException;
import java.util.Optional;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.protocol.core.methods.response.AppGetTransactionReceipt;
import org.nervos.appchain.protocol.core.methods.response.TransactionReceipt;
import org.nervos.appchain.protocol.exceptions.TransactionException;

public abstract class TransactionReceiptProcessor {
    private final AppChainj appChainj;

    public TransactionReceiptProcessor(AppChainj appChainj) {
        this.appChainj = appChainj;
    }

    public abstract TransactionReceipt waitForTransactionReceipt(String var1) throws IOException, TransactionException;

    Optional<TransactionReceipt> sendTransactionReceiptRequest(String transactionHash) throws IOException, TransactionException {
        AppGetTransactionReceipt transactionReceipt = this.appChainj.appGetTransactionReceipt(transactionHash).send();
        if (transactionReceipt.hasError()) {
            throw new TransactionException("Error processing request: " + transactionReceipt.getError().getMessage());
        }
        return transactionReceipt.getTransactionReceipt();
    }
}

