/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.console;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.nervos.appchain.codegen.Console;
import org.nervos.appchain.console.WalletManager;
import org.nervos.appchain.crypto.Credentials;
import org.nervos.appchain.crypto.WalletUtils;
import org.nervos.appchain.protocol.AppChainj;
import org.nervos.appchain.protocol.AppChainjService;
import org.nervos.appchain.protocol.core.methods.response.TransactionReceipt;
import org.nervos.appchain.protocol.exceptions.TransactionException;
import org.nervos.appchain.protocol.http.HttpService;
import org.nervos.appchain.protocol.infura.InfuraHttpService;
import org.nervos.appchain.tx.Transfer;
import org.nervos.appchain.utils.Convert;

public class WalletSendFunds
extends WalletManager {
    private static final String USAGE = "send <walletfile> <destination-address>";

    public static void main(String[] args) {
        if (args.length != 2) {
            Console.exitError((String)USAGE);
        } else {
            new WalletSendFunds().run(args[0], args[1]);
        }
    }

    private void run(String walletFileLocation, String destinationAddress) {
        File walletFile = new File(walletFileLocation);
        Credentials credentials = this.getCredentials(walletFile);
        this.console.printf("Wallet for address " + credentials.getAddress() + " loaded\n", new Object[0]);
        if (!WalletUtils.isValidAddress((String)destinationAddress)) {
            Console.exitError((String)"Invalid destination address specified");
        }
        AppChainj appChainj = this.getEthereumClient();
        BigDecimal amountToTransfer = this.getAmountToTransfer();
        Convert.Unit transferUnit = this.getTransferUnit();
        BigDecimal amountInWei = Convert.toWei((BigDecimal)amountToTransfer, (Convert.Unit)transferUnit);
        this.confirmTransfer(amountToTransfer, transferUnit, amountInWei, destinationAddress);
        TransactionReceipt transactionReceipt = this.performTransfer(appChainj, destinationAddress, credentials, amountInWei);
        this.console.printf("Funds have been successfully transferred from %s to %s%nTransaction hash: %s%nMined block number: %s%n", credentials.getAddress(), destinationAddress, transactionReceipt.getTransactionHash(), transactionReceipt.getBlockNumber());
    }

    private BigDecimal getAmountToTransfer() {
        String amount = this.console.readLine("What amound would you like to transfer (please enter a numeric value): ", new Object[0]).trim();
        try {
            return new BigDecimal(amount);
        }
        catch (NumberFormatException e) {
            Console.exitError((String)"Invalid amount specified");
            throw new RuntimeException("Application exit failure");
        }
    }

    private Convert.Unit getTransferUnit() {
        String unit = this.console.readLine("Please specify the unit (ether, wei, ...) [ether]: ", new Object[0]).trim();
        Convert.Unit transferUnit = unit.equals("") ? Convert.Unit.ETHER : Convert.Unit.fromString((String)unit.toLowerCase());
        return transferUnit;
    }

    private void confirmTransfer(BigDecimal amountToTransfer, Convert.Unit transferUnit, BigDecimal amountInWei, String destinationAddress) {
        this.console.printf("Please confim that you wish to transfer %s %s (%s %s) to address %s%n", amountToTransfer.stripTrailingZeros().toPlainString(), transferUnit, amountInWei.stripTrailingZeros().toPlainString(), Convert.Unit.WEI, destinationAddress);
        String confirm = this.console.readLine("Please type 'yes' to proceed: ", new Object[0]).trim();
        if (!confirm.toLowerCase().equals("yes")) {
            Console.exitError((String)"OK, some other time perhaps...");
        }
    }

    private TransactionReceipt performTransfer(AppChainj appChainj, String destinationAddress, Credentials credentials, BigDecimal amountInWei) {
        this.console.printf("Commencing transfer (this may take a few minutes) ", new Object[0]);
        try {
            CompletableFuture future = Transfer.sendFunds((AppChainj)appChainj, (Credentials)credentials, (String)destinationAddress, (BigDecimal)amountInWei, (Convert.Unit)Convert.Unit.WEI).sendAsync();
            while (!future.isDone()) {
                this.console.printf(".", new Object[0]);
                Thread.sleep(500L);
            }
            this.console.printf("$%n%n", new Object[0]);
            return (TransactionReceipt)future.get();
        }
        catch (IOException | InterruptedException | ExecutionException | TransactionException e) {
            Console.exitError((String)("Problem encountered transferring funds: \n" + e.getMessage()));
            throw new RuntimeException("Application exit failure");
        }
    }

    private AppChainj getEthereumClient() {
        String clientAddress = this.console.readLine("Please confirm address of running Ethereum client you wish to send the transfer request to [http://localhost:8545/]: ", new Object[0]).trim();
        AppChainj appChainj = clientAddress.equals("") ? AppChainj.build((AppChainjService)new HttpService()) : (clientAddress.contains("infura.io") ? AppChainj.build((AppChainjService)new InfuraHttpService(clientAddress)) : AppChainj.build((AppChainjService)new HttpService(clientAddress)));
        return appChainj;
    }
}

