/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.crypto;

import java.math.BigInteger;
import java.security.KeyPair;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.nervos.appchain.crypto.ECDSASignature;
import org.nervos.appchain.crypto.Sign;
import org.nervos.appchain.utils.Numeric;

public class ECKeyPair {
    private final BigInteger privateKey;
    private final BigInteger publicKey;

    public ECKeyPair(BigInteger privateKey, BigInteger publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public BigInteger getPrivateKey() {
        return this.privateKey;
    }

    public BigInteger getPublicKey() {
        return this.publicKey;
    }

    public ECDSASignature sign(byte[] transactionHash) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(this.privateKey, Sign.CURVE);
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(transactionHash);
        return new ECDSASignature(components[0], components[1]).toCanonicalised();
    }

    public static ECKeyPair create(KeyPair keyPair) {
        BCECPrivateKey privateKey = (BCECPrivateKey)keyPair.getPrivate();
        BCECPublicKey publicKey = (BCECPublicKey)keyPair.getPublic();
        BigInteger privateKeyValue = privateKey.getD();
        byte[] publicKeyBytes = publicKey.getQ().getEncoded(false);
        BigInteger publicKeyValue = new BigInteger(1, Arrays.copyOfRange(publicKeyBytes, 1, publicKeyBytes.length));
        return new ECKeyPair(privateKeyValue, publicKeyValue);
    }

    public static ECKeyPair create(BigInteger privateKey) {
        return new ECKeyPair(privateKey, Sign.publicKeyFromPrivate(privateKey));
    }

    public static ECKeyPair create(byte[] privateKey) {
        return ECKeyPair.create(Numeric.toBigInt((byte[])privateKey));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECKeyPair ecKeyPair = (ECKeyPair)o;
        if (this.privateKey != null ? !this.privateKey.equals(ecKeyPair.privateKey) : ecKeyPair.privateKey != null) {
            return false;
        }
        return this.publicKey != null ? this.publicKey.equals(ecKeyPair.publicKey) : ecKeyPair.publicKey == null;
    }

    public int hashCode() {
        int result = this.privateKey != null ? this.privateKey.hashCode() : 0;
        result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        return result;
    }
}

